/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.markenwerk.commons.interfaces.Predicate;

public final class FilteredIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Payload> iterator;
    private final Predicate<? super Payload> predicate;
    private final boolean satisfying;
    private boolean nextPrepared;
    private boolean nextDetected;
    private Payload next;
    private boolean nextCalled;

    public FilteredIterator(Iterator<? extends Payload> iterator, Predicate<? super Payload> predicate) throws IllegalArgumentException {
        this(iterator, predicate, false);
    }

    public FilteredIterator(Iterator<? extends Payload> iterator, Predicate<? super Payload> predicate, boolean invertPredicate) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        if (null == predicate) {
            throw new IllegalArgumentException("The given predicate is null");
        }
        this.iterator = iterator;
        this.predicate = predicate;
        this.satisfying = !invertPredicate;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return this.nextDetected;
    }

    @Override
    public Payload next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        this.nextCalled = true;
        this.nextPrepared = false;
        return this.next;
    }

    @Override
    public void remove() throws IllegalStateException, UnsupportedOperationException {
        if (!this.nextCalled) {
            throw new IllegalStateException("Method next() hasn't been called yet");
        }
        this.iterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.next = null;
            this.nextDetected = false;
            while (!this.nextDetected && this.iterator.hasNext()) {
                Payload nextPayload = this.iterator.next();
                if (this.satisfying != this.predicate.test(nextPayload)) continue;
                this.next = nextPayload;
                this.nextDetected = true;
            }
            this.nextPrepared = true;
        }
    }
}

