/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.markenwerk.commons.interfaces.Converter;

public final class ConvertingIterator<From, To>
implements Iterator<To> {
    private final Iterator<? extends From> iterator;
    private final Converter<? super From, ? extends To> converter;
    private boolean nextPrepared;
    private boolean nextDetected;
    private To next;
    private boolean nextCalled;

    public ConvertingIterator(Iterator<? extends From> iterator, Converter<? super From, ? extends To> converter) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        if (null == converter) {
            throw new IllegalArgumentException("The given converter is null");
        }
        this.iterator = iterator;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() throws NoSuchElementException {
        this.prepareNext();
        return this.nextDetected;
    }

    @Override
    public To next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        this.nextCalled = true;
        this.nextPrepared = false;
        return this.next;
    }

    @Override
    public void remove() throws IllegalStateException, UnsupportedOperationException {
        if (!this.nextCalled) {
            throw new IllegalStateException("Method next() hasn't been called yet");
        }
        this.iterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.next = null;
            this.nextDetected = false;
            while (!this.nextDetected && this.iterator.hasNext()) {
                From nextFrom = this.iterator.next();
                this.next = this.converter.convert(nextFrom);
                this.nextDetected = true;
            }
            this.nextPrepared = true;
        }
    }
}

