/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.markenwerk.commons.iterators.ArrayIterator;

public final class CombinedIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Iterator<? extends Payload>> iterators;
    private Iterator<? extends Payload> currentIterator;
    private boolean nextPrepared;
    private boolean hasNext;
    private boolean nextCalled;

    public CombinedIterator(Iterator<? extends Payload> ... iterators) throws IllegalArgumentException {
        if (null == iterators) {
            throw new IllegalArgumentException("The given array of iterators is null");
        }
        this.iterators = new ArrayIterator<Iterator<? extends Iterator<? extends Payload>>>(iterators);
    }

    public CombinedIterator(Iterable<? extends Iterator<? extends Payload>> iterators) throws IllegalArgumentException {
        if (null == iterators) {
            throw new IllegalArgumentException("The given iterable of iterators is null");
        }
        this.iterators = iterators.iterator();
    }

    public CombinedIterator(Iterator<? extends Iterator<? extends Payload>> iterators) throws IllegalArgumentException {
        if (null == iterators) {
            throw new IllegalArgumentException("The given iterator of iterators is null");
        }
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return this.hasNext;
    }

    @Override
    public Payload next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        this.nextCalled = true;
        this.nextPrepared = false;
        return this.currentIterator.next();
    }

    @Override
    public void remove() throws IllegalStateException, UnsupportedOperationException {
        if (!this.nextCalled) {
            throw new IllegalStateException("Method next() hasn't been called yet");
        }
        this.currentIterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.hasNext = false;
            if (null != this.currentIterator && this.currentIterator.hasNext()) {
                this.hasNext = true;
            } else {
                while (!this.hasNext && this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    this.hasNext = this.currentIterator.hasNext();
                }
            }
            this.nextPrepared = true;
        }
    }
}

