/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.NoSuchElementException;
import net.markenwerk.commons.iterators.AbstractProtectedBidirectionalIterator;

public abstract class AbstractIndexedIterator<Payload>
extends AbstractProtectedBidirectionalIterator<Payload> {
    private final int maxIndex;
    private int index;

    protected AbstractIndexedIterator(int startIndex, int maxIndex) throws IllegalArgumentException {
        if (startIndex < 0) {
            throw new IllegalArgumentException("The given start index is negative: " + startIndex);
        }
        if (maxIndex < startIndex) {
            throw new IllegalArgumentException("The given maximum index is smaller than the given start index '" + startIndex + "': " + maxIndex);
        }
        this.index = startIndex;
        this.maxIndex = maxIndex;
    }

    @Override
    public final boolean hasNext() {
        return this.index < this.maxIndex;
    }

    @Override
    public final Payload next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        return this.get(this.index++);
    }

    @Override
    public final boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public final Payload previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("This iterator has no previous element");
        }
        return this.get(--this.index);
    }

    protected abstract Payload get(int var1);
}

