/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class ByteArrayIterator
implements Iterator<Byte> {
    private final byte[] values;
    private final Byte replacement;
    private int index = -1;

    public ByteArrayIterator(byte[] values) {
        this(values, null);
    }

    public ByteArrayIterator(byte[] values, byte replacement) {
        this(values, (Byte)replacement);
    }

    private ByteArrayIterator(byte[] values, Byte replacement) {
        this.values = null == values ? new byte[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Byte next() {
        ++this.index;
        return this.values[this.index];
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement;
    }
}

