/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class BooleanArrayIterator
implements Iterator<Boolean> {
    private final boolean[] values;
    private final Boolean replacement;
    private int index = -1;

    public BooleanArrayIterator(boolean[] values) {
        this(values, null);
    }

    public BooleanArrayIterator(boolean[] values, boolean replacement) {
        this(values, (Boolean)replacement);
    }

    private BooleanArrayIterator(boolean[] values, Boolean replacement) {
        this.values = null == values ? new boolean[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Boolean next() {
        ++this.index;
        return this.values[this.index];
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement;
    }
}

