/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class ArrayIterator<Payload>
implements Iterator<Payload> {
    private final Payload[] values;
    private final boolean removable;
    private final Payload replacement;
    private int index = -1;

    public ArrayIterator(Payload[] values) {
        this(values, false, null);
    }

    public ArrayIterator(Payload[] values, Payload replacement) {
        this(values, true, replacement);
    }

    private ArrayIterator(Payload[] values, boolean removable, Payload replacement) {
        this.values = null == values ? new Object[]{} : values;
        this.removable = removable;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Payload next() {
        ++this.index;
        return this.values[this.index];
    }

    @Override
    public void remove() {
        if (!this.removable) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement;
    }
}

