/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class ShortArrayIterator
implements Iterator<Short> {
    private final short[] values;
    private final Short replacement;
    private int index = -1;

    public ShortArrayIterator(short[] values) {
        this(values, null);
    }

    public ShortArrayIterator(short[] values, short replacement) {
        this(values, (Short)replacement);
    }

    private ShortArrayIterator(short[] values, Short replacement) {
        this.values = null == values ? new short[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Short next() {
        ++this.index;
        return this.values[this.index];
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement;
    }
}

