/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class IntegerArrayIterator
implements Iterator<Integer> {
    private final int[] values;
    private final Integer replacement;
    private int index = -1;

    public IntegerArrayIterator(int[] values) {
        this(values, null);
    }

    public IntegerArrayIterator(int[] values, int replacement) {
        this(values, (Integer)replacement);
    }

    private IntegerArrayIterator(int[] values, Integer replacement) {
        this.values = null == values ? new int[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Integer next() {
        ++this.index;
        return this.values[this.index];
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement;
    }
}

