/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class CharacterArrayIterator
implements Iterator<Character> {
    private final char[] values;
    private final Character replacement;
    private int index = -1;

    public CharacterArrayIterator(char[] values) {
        this(values, null);
    }

    public CharacterArrayIterator(char[] values, char replacement) {
        this(values, Character.valueOf(replacement));
    }

    private CharacterArrayIterator(char[] values, Character replacement) {
        this.values = null == values ? new char[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Character next() {
        ++this.index;
        return Character.valueOf(this.values[this.index]);
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement.charValue();
    }
}

