/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class NullFreeIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<Payload> iterator;
    private boolean nextPrepared;
    private Payload next;

    public NullFreeIterator(Iterator<Payload> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return null != this.next;
    }

    @Override
    public Payload next() {
        this.prepareNext();
        this.nextPrepared = false;
        return this.next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.next = null;
            while (null == this.next && this.iterator.hasNext()) {
                this.next = this.iterator.next();
            }
            this.nextPrepared = true;
        }
    }
}

