/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class LongArrayIterator
implements Iterator<Long> {
    private final long[] values;
    private final Long replacement;
    private int index = -1;

    public LongArrayIterator(long[] values) {
        this(values, null);
    }

    public LongArrayIterator(long[] values, long replacement) {
        this(values, (Long)replacement);
    }

    private LongArrayIterator(long[] values, Long replacement) {
        this.values = null == values ? new long[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Long next() {
        ++this.index;
        return this.values[this.index];
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement;
    }
}

