/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class FloatArrayIterator
implements Iterator<Float> {
    private final float[] values;
    private final Float replacement;
    private int index = -1;

    public FloatArrayIterator(float[] values) {
        this(values, null);
    }

    public FloatArrayIterator(float[] values, float replacement) {
        this(values, Float.valueOf(replacement));
    }

    private FloatArrayIterator(float[] values, Float replacement) {
        this.values = null == values ? new float[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Float next() {
        ++this.index;
        return Float.valueOf(this.values[this.index]);
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement.floatValue();
    }
}

