/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;

public final class DoubleArrayIterator
implements Iterator<Double> {
    private final double[] values;
    private final Double replacement;
    private int index = -1;

    public DoubleArrayIterator(double[] values) {
        this(values, null);
    }

    public DoubleArrayIterator(double[] values, double replacement) {
        this(values, (Double)replacement);
    }

    private DoubleArrayIterator(double[] values, Double replacement) {
        this.values = null == values ? new double[]{} : values;
        this.replacement = replacement;
    }

    @Override
    public boolean hasNext() {
        return this.values.length != this.index + 1;
    }

    @Override
    public Double next() {
        ++this.index;
        return this.values[this.index];
    }

    @Override
    public void remove() {
        if (null == this.replacement) {
            throw new UnsupportedOperationException("Cannot remove from an array.");
        }
        this.values[this.index] = this.replacement;
    }
}

