/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import net.markenwerk.commons.interfaces.Predicate;

public class FilteringIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<Payload> iterator;
    private final Predicate<Payload> predicate;
    private boolean nextPrepared;
    private boolean nextDetected;
    private Payload next;

    public FilteringIterator(Iterator<Payload> iterator, Predicate<Payload> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return this.nextDetected;
    }

    @Override
    public Payload next() {
        this.prepareNext();
        this.nextPrepared = false;
        return this.next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.next = null;
            this.nextDetected = false;
            while (!this.nextDetected && this.iterator.hasNext()) {
                Payload nextPayload = this.iterator.next();
                if (!this.predicate.test(nextPayload)) continue;
                this.next = nextPayload;
                this.nextDetected = true;
            }
            this.nextPrepared = true;
        }
    }
}

