/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import net.markenwerk.commons.interfaces.Converter;

public class ConvertingIterator<From, To>
implements Iterator<To> {
    private final Iterator<From> iterator;
    private final Converter<From, To> converter;
    private boolean nextPrepared;
    private boolean nextDetected;
    private To next;

    public ConvertingIterator(Iterator<From> iterator, Converter<From, To> converter) {
        this.iterator = iterator;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return this.nextDetected;
    }

    @Override
    public To next() {
        this.prepareNext();
        this.nextPrepared = false;
        return this.next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.next = null;
            this.nextDetected = false;
            while (!this.nextDetected && this.iterator.hasNext()) {
                From nextFrom = this.iterator.next();
                this.next = this.converter.convert(nextFrom);
                this.nextDetected = true;
            }
            this.nextPrepared = true;
        }
    }
}

