/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import net.markenwerk.commons.iterators.ArrayIterator;

public class CombinedIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Iterator<? extends Payload>> iterators;
    private Iterator<? extends Payload> currentIterator;
    private boolean nextPrepared;
    private boolean hasNext;

    public CombinedIterator(Iterator<? extends Payload> ... iterators) {
        this((Iterator<Iterator<? extends Payload>>)new ArrayIterator<Iterator<? extends Payload>>(iterators));
    }

    public CombinedIterator(Iterable<? extends Iterator<? extends Payload>> iterable) {
        this((Iterator<Iterator<Payload>>)iterable.iterator());
    }

    public CombinedIterator(Iterator<? extends Iterator<? extends Payload>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return this.hasNext;
    }

    @Override
    public Payload next() {
        this.prepareNext();
        this.nextPrepared = false;
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.hasNext = false;
            if (null != this.currentIterator && this.currentIterator.hasNext()) {
                this.hasNext = true;
            } else if (this.iterators.hasNext()) {
                this.currentIterator = this.iterators.next();
                this.hasNext = this.currentIterator.hasNext();
            }
            this.nextPrepared = true;
        }
    }
}

