/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterables;

import net.markenwerk.commons.iterators.FloatArrayIterator;

public final class FloatArrayIterable
implements Iterable<Float> {
    private final float[] array;
    private final Float replacement;

    public FloatArrayIterable(float[] array) throws IllegalArgumentException {
        this(array, null);
    }

    public FloatArrayIterable(float[] array, float replacement) throws IllegalArgumentException {
        this(array, Float.valueOf(replacement));
    }

    private FloatArrayIterable(float[] array, Float replacement) throws IllegalArgumentException {
        if (null == array) {
            throw new IllegalArgumentException("array is null");
        }
        this.array = array;
        this.replacement = replacement;
    }

    public FloatArrayIterator iterator() {
        return null != this.replacement ? new FloatArrayIterator(this.array, this.replacement.floatValue()) : new FloatArrayIterator(this.array);
    }
}

