/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterables;

import net.markenwerk.commons.iterators.ByteArrayIterator;

public final class ByteArrayIterable
implements Iterable<Byte> {
    private final byte[] array;
    private final Byte replacement;

    public ByteArrayIterable(byte[] array) throws IllegalArgumentException {
        this(array, null);
    }

    public ByteArrayIterable(byte[] array, byte replacement) throws IllegalArgumentException {
        this(array, (Byte)replacement);
    }

    private ByteArrayIterable(byte[] array, Byte replacement) throws IllegalArgumentException {
        if (null == array) {
            throw new IllegalArgumentException("array is null");
        }
        this.array = array;
        this.replacement = replacement;
    }

    public ByteArrayIterator iterator() {
        return null != this.replacement ? new ByteArrayIterator(this.array, this.replacement.byteValue()) : new ByteArrayIterator(this.array);
    }
}

