/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterables;

import net.markenwerk.commons.iterators.ArrayIterator;

public final class ArrayIterable<Payload>
implements Iterable<Payload> {
    private final Payload[] array;
    private final boolean removable;
    private final Payload replacement;

    public ArrayIterable(Payload[] array) throws IllegalArgumentException {
        this(array, false, null);
    }

    public ArrayIterable(Payload[] array, Payload replacement) throws IllegalArgumentException {
        this(array, true, replacement);
    }

    private ArrayIterable(Payload[] array, boolean removable, Payload replacement) throws IllegalArgumentException {
        if (null == array) {
            throw new IllegalArgumentException("array is null");
        }
        this.array = array;
        this.removable = removable;
        this.replacement = replacement;
    }

    @Override
    public ArrayIterator<Payload> iterator() {
        return this.removable ? new ArrayIterator((Object[])this.array, this.replacement) : new ArrayIterator((Object[])this.array);
    }
}

