/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.datastructures;

import java.util.NoSuchElementException;
import net.markenwerk.commons.datastructures.ConvertingOptionalSelection;
import net.markenwerk.commons.datastructures.OptionalSelection;
import net.markenwerk.commons.exceptions.ProvisioningException;
import net.markenwerk.commons.interfaces.Converter;
import net.markenwerk.commons.interfaces.Provider;

public final class Optional<Payload> {
    private final boolean hasValue;
    private final Payload value;

    public Optional() {
        this(null, true);
    }

    public Optional(Payload value) {
        this(value, false);
    }

    public Optional(Payload value, boolean ignoreNull) {
        if (null == value && ignoreNull) {
            this.hasValue = false;
            this.value = null;
        } else {
            this.hasValue = true;
            this.value = value;
        }
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public Payload getValue() throws NoSuchElementException {
        if (!this.hasValue) {
            throw new NoSuchElementException("This optional has no value");
        }
        return this.value;
    }

    public Payload getValue(Payload fallback) {
        return this.hasValue ? this.value : fallback;
    }

    public Payload getValue(Provider<? extends Payload> provider) throws IllegalArgumentException, ProvisioningException {
        if (null == provider) {
            throw new IllegalArgumentException("The given provider is null");
        }
        return (Payload)(this.hasValue ? this.value : provider.provide());
    }

    public <Result> Optional<Result> convert(Converter<? super Payload, ? extends Result> converter) throws IllegalArgumentException {
        return (Optional)this.select(new ConvertingOptionalSelection<Payload, Result>(converter));
    }

    public <Result> Result select(OptionalSelection<? super Payload, ? extends Result> selection) throws IllegalArgumentException {
        if (null == selection) {
            throw new IllegalArgumentException("The given selection is null");
        }
        return this.hasValue ? selection.onValue(this.value) : selection.onNoValue();
    }

    public int hashCode() {
        return 31 * (this.hasValue ? 1231 : 1237) + (null == this.value ? 0 : this.value.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Optional other = (Optional)object;
        if (this.hasValue != other.hasValue) {
            return false;
        }
        return !(null == this.value ? null != other.value : !this.value.equals(other.value));
    }

    public String toString() {
        return "Optional [hasValue=" + this.hasValue + ", value=" + this.value + "]";
    }
}

