/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.datastructures;

public final class Entry<Key, Value> {
    private final Key key;
    private final Value value;

    public Entry(Key key, Value value) {
        this.key = key;
        this.value = value;
    }

    public Key getKey() {
        return this.key;
    }

    public Entry<Key, Value> withKey(Key key) {
        return new Entry<Key, Value>(key, this.value);
    }

    public Value getValue() {
        return this.value;
    }

    public Entry<Key, Value> withValue(Value value) {
        return new Entry<Key, Value>(this.key, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Entry other = (Entry)object;
        if (this.key == null && other.key != null || !this.key.equals(other.key)) {
            return false;
        }
        return (this.value != null || other.value == null) && this.value.equals(other.value);
    }

    public String toString() {
        return "Entry [key=" + this.key + ", value=" + this.value + "]";
    }
}

