/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.compiler.mavenplugin;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.maritimecloud.internal.msdl.compiler.mavenplugin.AdaptedMsdlLogger;
import net.maritimecloud.internal.msdl.compiler.mavenplugin.FileTools;
import net.maritimecloud.msdl.MsdlLogger;
import net.maritimecloud.msdl.MsdlPlugin;
import net.maritimecloud.msdl.MsdlProcessor;
import net.maritimecloud.msdl.MsdlProcessorResult;
import net.maritimecloud.msdl.plugins.javagen.JavaGenPlugin;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.sonatype.plexus.build.incremental.BuildContext;

abstract class AbstractMsdlMojo
extends AbstractMojo {
    private static final String MSDL_FILE_SUFFIX = ".msdl";
    private static final String DEFAULT_INCLUDES = "**/*.msdl";
    @Component
    protected MavenProject project;
    @Component
    private MavenSession session;
    @Component
    protected BuildContext buildContext;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(required=true, readonly=true, property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(required=false)
    private boolean implementsSerializable;
    @Parameter(required=false)
    private File[] additionalProtoPathElements = new File[0];
    @Parameter(required=true, defaultValue="${project.build.directory}/msdl-dependencies")
    private File temporaryMSDLDirectory;
    @Parameter(required=true, defaultValue="false")
    private boolean hashDependentPaths;
    @Parameter(required=false)
    private Set<String> includes = ImmutableSet.of((Object)"**/*.msdl");
    @Parameter(required=false)
    private Set<String> excludes = ImmutableSet.of();
    @Parameter(required=true, defaultValue="${project.build.finalName}.protobin")
    private String descriptorSetFileName;
    @Parameter(required=true, defaultValue="false")
    private boolean writeDescriptorSet;
    @Parameter(required=false, defaultValue="false")
    private boolean includeDependenciesInDescriptorSet;
    @Parameter(required=false, defaultValue="0")
    private long staleMillis;
    @Parameter(required=false, defaultValue="false")
    private boolean checkStaleness;
    @Parameter(required=false, property="msdl.skip", defaultValue="false")
    private boolean skip;
    @Parameter(required=false)
    protected String headerLocation;
    @Parameter(required=false, property="msdl.force", defaultValue="false")
    private boolean forceMojoExecution;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    AbstractMsdlMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMojo()) {
            return;
        }
        this.checkParameters();
        File msdlSourceRoot = this.getMsdlSourceRoot();
        if (msdlSourceRoot.exists()) {
            try {
                Set<File> msdlFiles = this.findMsdlFilesInDirectory(msdlSourceRoot);
                File outputDirectory = this.getOutputDirectory();
                Set<File> outputFiles = AbstractMsdlMojo.findGeneratedFilesInDirectory(this.getOutputDirectory());
                if (msdlFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No msdl files to compile.");
                }
                if (!this.hasDelta(msdlFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because build context has no changes.");
                    this.attachFiles();
                }
                if (this.checkStaleness && this.checkFilesUpToDate(msdlFiles, outputFiles)) {
                    this.getLog().info((CharSequence)"Skipping compilation because target directory newer than sources.");
                    this.attachFiles();
                }
                Set<File> derivedMsdlPathElements = this.makeMsdlPathFromJars(this.temporaryMSDLDirectory, this.getDependencyArtifactFiles());
                FileUtils.mkdir((String)outputDirectory.getAbsolutePath());
                FileUtils.cleanDirectory((File)outputDirectory);
                if (this.writeDescriptorSet) {
                    File descriptorSetOutputDirectory = this.getDescriptorSetOutputDirectory();
                    FileUtils.mkdir((String)descriptorSetOutputDirectory.getAbsolutePath());
                    FileUtils.cleanDirectory((File)descriptorSetOutputDirectory);
                }
                MsdlProcessor g = new MsdlProcessor();
                g.setSourceDirectory(msdlSourceRoot.toPath());
                for (File file : derivedMsdlPathElements) {
                    g.addDependencyDirectory(file.toPath());
                }
                for (File file : msdlFiles) {
                    g.addFile(file.toPath());
                }
                JavaGenPlugin javaPlugin = JavaGenPlugin.create((Path)outputDirectory.toPath());
                javaPlugin.setImplementsSerializable(this.implementsSerializable);
                this.getLog().debug((CharSequence)("Setting implements serialiable = " + this.implementsSerializable));
                g.addPlugin((MsdlPlugin)javaPlugin);
                if (this.headerLocation != null) {
                    Path path = Paths.get(this.headerLocation, new String[0]).toAbsolutePath();
                    if (!Files.exists(path, new LinkOption[0])) {
                        this.getLog().warn((CharSequence)("Could not find headerFile: " + path));
                    } else {
                        javaPlugin.setHeader(path);
                    }
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Msdl source root:");
                    this.getLog().debug((CharSequence)(" " + msdlSourceRoot));
                    if (derivedMsdlPathElements != null && !derivedMsdlPathElements.isEmpty()) {
                        this.getLog().debug((CharSequence)"Derived msdl paths:");
                        for (File path : derivedMsdlPathElements) {
                            this.getLog().debug((CharSequence)(" " + path));
                        }
                    }
                    if (this.additionalProtoPathElements != null && this.additionalProtoPathElements.length > 0) {
                        this.getLog().debug((CharSequence)"Additional proto paths:");
                        for (File path : this.additionalProtoPathElements) {
                            this.getLog().debug((CharSequence)(" " + path));
                        }
                    }
                }
                g.setLogger((MsdlLogger)new AdaptedMsdlLogger(this.getLog()));
                MsdlProcessorResult msdlProcessorResult = g.executePlugins();
                if (!msdlProcessorResult.isSuccesfull()) {
                    throw new MojoFailureException("Compilation failed. Review output for more information.");
                }
                this.getLog().info((CharSequence)"Files succesfully generated");
                this.attachFiles();
            }
            catch (IOException e) {
                throw new MojoExecutionException("An IO error occured", (Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("Compiler failed to execute because: " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.getLog().info((CharSequence)String.format("%s does not exist. Review the configuration or consider disabling the plugin.", msdlSourceRoot));
        }
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping msdl mojo execution");
            return true;
        }
        if (!this.forceMojoExecution && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping protoc mojo execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    protected static Set<File> findGeneratedFilesInDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            return Collections.emptySet();
        }
        return new HashSet<File>(FileUtils.getFiles((File)directory, (String)"**/*.java", null));
    }

    protected boolean checkFilesUpToDate(Set<File> sourceFiles, Set<File> targetFiles) {
        return FileTools.lastModified(sourceFiles) + this.staleMillis < FileTools.lastModified(targetFiles);
    }

    protected boolean hasDelta(Set<File> files) {
        for (File file : files) {
            if (!this.buildContext.hasDelta(file)) continue;
            return true;
        }
        return false;
    }

    protected void checkParameters() {
        Preconditions.checkNotNull((Object)this.project, (Object)"project");
        Preconditions.checkNotNull((Object)this.projectHelper, (Object)"projectHelper");
        File msdlSourceRoot = this.getMsdlSourceRoot();
        Preconditions.checkNotNull((Object)msdlSourceRoot);
        Preconditions.checkArgument((!msdlSourceRoot.isFile() ? 1 : 0) != 0, (Object)"msdlSourceRoot is a file, not a directory");
        Preconditions.checkNotNull((Object)this.temporaryMSDLDirectory, (Object)"temporaryMsdlFileDirectory");
        Preconditions.checkState((!this.temporaryMSDLDirectory.isFile() ? 1 : 0) != 0, (Object)"temporaryMsdlFileDirectory is a file, not a directory");
        File outputDirectory = this.getOutputDirectory();
        Preconditions.checkNotNull((Object)outputDirectory);
        Preconditions.checkState((!outputDirectory.isFile() ? 1 : 0) != 0, (Object)"the outputDirectory is a file, not a directory");
    }

    protected abstract File getMsdlSourceRoot();

    protected abstract List<Artifact> getDependencyArtifacts();

    protected abstract File getOutputDirectory();

    protected abstract File getDescriptorSetOutputDirectory();

    protected abstract void attachFiles();

    protected Set<File> getDependencyArtifactFiles() {
        HashSet<File> dependencyArtifactFiles = new HashSet<File>();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            dependencyArtifactFiles.add(artifact.getFile());
        }
        return dependencyArtifactFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<File> makeMsdlPathFromJars(File temporaryProtoFileDirectory, Iterable<File> classpathElementFiles) throws IOException, MojoExecutionException {
        Preconditions.checkNotNull(classpathElementFiles, (Object)"classpathElementFiles");
        if (!classpathElementFiles.iterator().hasNext()) {
            return Collections.emptySet();
        }
        if (temporaryProtoFileDirectory.exists()) {
            FileUtils.cleanDirectory((File)temporaryProtoFileDirectory);
        }
        HashSet<File> protoDirectories = new HashSet<File>();
        for (File classpathElementFile : classpathElementFiles) {
            List protoFiles;
            if (classpathElementFile.isFile() && classpathElementFile.canRead() && !classpathElementFile.getName().endsWith(".xml")) {
                JarFile classpathJar;
                try {
                    classpathJar = new JarFile(classpathElementFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("%s was not a readable artifact", classpathElementFile), e);
                }
                try {
                    Enumeration<JarEntry> jarEntries = classpathJar.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry jarEntry = jarEntries.nextElement();
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntryName.endsWith(MSDL_FILE_SUFFIX)) continue;
                        File jarDirectory = new File(temporaryProtoFileDirectory, this.truncatePath(classpathJar.getName()));
                        File uncompressedCopy = new File(jarDirectory, jarEntryName);
                        FileUtils.mkdir((String)uncompressedCopy.getParentFile().getAbsolutePath());
                        FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(classpathJar.getInputStream(jarEntry)), (File)uncompressedCopy);
                        protoDirectories.add(jarDirectory);
                    }
                    continue;
                }
                finally {
                    classpathJar.close();
                    continue;
                }
            }
            if (!classpathElementFile.isDirectory() || (protoFiles = FileUtils.getFiles((File)classpathElementFile, (String)DEFAULT_INCLUDES, null)).isEmpty()) continue;
            protoDirectories.add(classpathElementFile);
        }
        return ImmutableSet.copyOf(protoDirectories);
    }

    protected Set<File> findMsdlFilesInDirectory(File directory) throws IOException {
        Objects.requireNonNull(directory);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"%s is not a directory", (Object[])new Object[]{directory});
        Joiner joiner = Joiner.on((char)',');
        List protoFilesInDirectory = FileUtils.getFiles((File)directory, (String)joiner.join(this.includes), (String)joiner.join(this.excludes));
        return ImmutableSet.copyOf((Collection)protoFilesInDirectory);
    }

    protected String truncatePath(String jarPath) throws MojoExecutionException {
        int colonIndex;
        String path;
        int repositoryIndex;
        if (this.hashDependentPaths) {
            try {
                return AbstractMsdlMojo.toHexString(MessageDigest.getInstance("MD5").digest(jarPath.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new MojoExecutionException("Failed to expand dependent jar", (Exception)e);
            }
        }
        String repository = this.localRepository.getBasedir().replace('\\', '/');
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        if ((repositoryIndex = (path = jarPath.replace('\\', '/')).indexOf(repository)) != -1) {
            path = path.substring(repositoryIndex + repository.length());
        }
        if ((colonIndex = path.indexOf(58)) != -1) {
            path = path.substring(colonIndex + 2);
        }
        return path;
    }

    protected static String toHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hexString.append(HEX_CHARS[(b & 0xF0) >> 4]).append(HEX_CHARS[b & 0xF]);
        }
        return hexString.toString();
    }
}

