/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.msdl.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.maritimecloud.message.Message;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public enum BaseType {
    BINARY(Binary.class),
    BOOLEAN(Boolean.class),
    DECIMAL(BigDecimal.class),
    DOUBLE(Double.class),
    ENUM(Enum.class),
    FLOAT(Float.class),
    INT(Integer.class),
    INT64(Long.class),
    LIST(List.class),
    MAP(Map.class),
    MESSAGE(Message.class),
    POSITION(Position.class),
    POSITION_TIME(PositionTime.class),
    SET(Set.class),
    TEXT(String.class),
    TIMESTAMP(Timestamp.class),
    VARINT(BigInteger.class);

    final Class<?> javaType;

    private BaseType(Class<?> javaType) {
        this.javaType = Objects.requireNonNull(javaType);
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public boolean isAnyOf(BaseType ... states) {
        for (BaseType s : states) {
            if (s != this) continue;
            return true;
        }
        return false;
    }

    public boolean isComplexType() {
        return this == LIST || this == SET || this == MAP;
    }

    public boolean isPrimitive() {
        return !this.isComplexType() && !this.isReferenceType();
    }

    public boolean isReferenceType() {
        return this == ENUM || this == MESSAGE;
    }
}

