/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.msdl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.maritimecloud.internal.msdl.parser.ParsedProject;
import net.maritimecloud.msdl.MsdlLogger;
import net.maritimecloud.msdl.MsdlPlugin;
import net.maritimecloud.msdl.MsdlPluginException;
import net.maritimecloud.msdl.MsdlProcessorResult;
import net.maritimecloud.msdl.model.Project;

public class MsdlProcessor {
    final List<Path> dependencyDirectories = new ArrayList<Path>();
    final Set<Path> files = new LinkedHashSet<Path>();
    MsdlLogger logger;
    final List<MsdlPlugin> plugins = new ArrayList<MsdlPlugin>();
    Path sourceDirectory = Paths.get("", new String[0]).toAbsolutePath();

    public MsdlProcessor addDependencyDirectory(Path p) {
        this.dependencyDirectories.add(p);
        return this;
    }

    public MsdlProcessor addFile(Path path) {
        this.files.add(Objects.requireNonNull(path));
        return this;
    }

    public MsdlProcessor addFile(String path) {
        return this.addFile(Paths.get(path, new String[0]));
    }

    public MsdlProcessor addPlugin(MsdlPlugin plugin) {
        this.plugins.add(Objects.requireNonNull(plugin));
        return this;
    }

    private Map<String, Path> checkFiles(MsdlLogger logger) {
        LinkedHashMap<String, Path> m = new LinkedHashMap<String, Path>();
        for (Path p : this.getFiles()) {
            if (p.isAbsolute()) {
                Path parent;
                if (!Files.exists(p, new LinkOption[0])) {
                    logger.error("Could not find file " + p);
                }
                for (parent = p.getParent(); parent != null; parent = parent.getParent()) {
                    if (!parent.equals(this.getSourceDirectory())) continue;
                    m.put(this.getSourceDirectory().relativize(p).toString(), p);
                    break;
                }
                if (parent != null) continue;
                logger.error("All .msdl files must must be located in " + this.getSourceDirectory() + ", was " + p);
                continue;
            }
            Path file = this.getSourceDirectory().resolve(p);
            if (!Files.exists(file, new LinkOption[0])) {
                logger.error("Could not find file " + p + " at " + file);
            }
            m.put(this.getSourceDirectory().relativize(file).toString(), file.toAbsolutePath());
            logger.debug("Found file: " + file.toAbsolutePath());
        }
        return m;
    }

    public MsdlProcessorResult executePlugins() {
        if (this.plugins.size() == 0) {
            throw new IllegalStateException("No plugins have been registered for execution");
        }
        MsdlLogger log = this.logger;
        if (log == null) {
            Logger lo = Logger.getLogger("msdl");
            for (Handler h : lo.getParent().getHandlers()) {
                h.setLevel(Level.FINE);
                h.setFormatter(new SimpleFormatter(){

                    @Override
                    public String format(LogRecord record) {
                        String throwable = "";
                        if (record.getThrown() != null) {
                            StringWriter sw = new StringWriter();
                            try (PrintWriter pw = new PrintWriter(sw);){
                                record.getThrown().printStackTrace(pw);
                            }
                            throwable = sw.toString();
                        }
                        return new Date() + " " + record.getLevel() + " " + record.getMessage() + "\r\n" + throwable;
                    }
                });
            }
            log = MsdlLogger.wrapJUL(lo);
        }
        AtomicInteger errorCounter = new AtomicInteger();
        log = MsdlLogger.errorCountingLogger(log, errorCounter);
        Map<String, Path> sourceFiles = this.checkFiles(log);
        if (errorCounter.get() > 0) {
            return new MsdlProcessorResult("One or more files could not be found");
        }
        ParsedProject pp = new ParsedProject(sourceFiles, this.dependencyDirectories, log);
        Project p = pp.parse();
        if (errorCounter.get() > 0 || p == null) {
            return new MsdlProcessorResult("Failed to properly parse MSDL files");
        }
        for (MsdlPlugin plugin : this.plugins) {
            plugin.logger = log;
            log.info("Processing plugin: " + plugin.getClass().getSimpleName());
            try {
                plugin.process(p);
            }
            catch (MsdlPluginException e) {
                return new MsdlProcessorResult("Plugin failed");
            }
            catch (Exception e) {
                log.error("Plugin failed", e);
            }
            if (errorCounter.get() <= 0) continue;
            return new MsdlProcessorResult("Plugin failed");
        }
        return new MsdlProcessorResult(null);
    }

    public List<Path> getDependencyDirectories() {
        return this.dependencyDirectories;
    }

    public Collection<Path> getFiles() {
        return this.files;
    }

    public MsdlLogger getLogger() {
        return this.logger;
    }

    public Path getSourceDirectory() {
        return this.sourceDirectory;
    }

    public MsdlProcessor setLogger(MsdlLogger logger) {
        this.logger = Objects.requireNonNull(logger);
        return this;
    }

    public MsdlProcessor setSourceDirectory(Path p) {
        this.sourceDirectory = p.toAbsolutePath();
        return this;
    }
}

