/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.msdl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MsdlLogger {
    public abstract void debug(CharSequence var1);

    public abstract void debug(CharSequence var1, Throwable var2);

    public abstract void error(CharSequence var1);

    public abstract void error(CharSequence var1, Throwable var2);

    public abstract void info(CharSequence var1);

    public abstract void info(CharSequence var1, Throwable var2);

    public abstract void warn(CharSequence var1);

    public abstract void warn(CharSequence var1, Throwable var2);

    public static MsdlLogger errorCountingLogger(MsdlLogger logger, AtomicInteger errorCounter) {
        return new ErrorCountingWrapper(logger, errorCounter);
    }

    public static MsdlLogger wrapJUL(Logger logger) {
        return new JULLogger(logger);
    }

    static class JULLogger
    extends MsdlLogger {
        private final Logger logger;

        JULLogger(Logger logger) {
            this.logger = Objects.requireNonNull(logger);
        }

        @Override
        public void debug(CharSequence message) {
            this.logger.log(Level.FINE, message.toString());
        }

        @Override
        public void debug(CharSequence message, Throwable error) {
            this.logger.log(Level.FINE, message.toString(), error);
        }

        @Override
        public void error(CharSequence message) {
            this.logger.log(Level.SEVERE, message.toString());
        }

        @Override
        public void error(CharSequence message, Throwable error) {
            this.logger.log(Level.SEVERE, message.toString(), error);
        }

        @Override
        public void info(CharSequence message) {
            this.logger.log(Level.INFO, message.toString());
        }

        @Override
        public void info(CharSequence message, Throwable error) {
            this.logger.log(Level.INFO, message.toString(), error);
        }

        @Override
        public void warn(CharSequence message) {
            this.logger.log(Level.WARNING, message.toString());
        }

        @Override
        public void warn(CharSequence message, Throwable error) {
            this.logger.log(Level.WARNING, message.toString(), error);
        }
    }

    static class ErrorCountingWrapper
    extends MsdlLogger {
        final AtomicInteger errorCounter;
        final MsdlLogger logger;

        ErrorCountingWrapper(MsdlLogger logger, AtomicInteger errorCounter) {
            this.logger = Objects.requireNonNull(logger);
            this.errorCounter = Objects.requireNonNull(errorCounter);
        }

        @Override
        public void debug(CharSequence message) {
            this.logger.debug(message);
        }

        @Override
        public void debug(CharSequence message, Throwable error) {
            this.logger.debug(message, error);
        }

        @Override
        public void error(CharSequence message) {
            this.errorCounter.incrementAndGet();
            this.logger.error(message);
        }

        @Override
        public void error(CharSequence message, Throwable error) {
            this.errorCounter.incrementAndGet();
            this.logger.error(message, error);
        }

        @Override
        public void info(CharSequence message) {
            this.logger.info(message);
        }

        @Override
        public void info(CharSequence message, Throwable error) {
            this.logger.info(message, error);
        }

        @Override
        public void warn(CharSequence message) {
            this.logger.warn(message);
        }

        @Override
        public void warn(CharSequence message, Throwable error) {
            this.logger.warn(message, error);
        }
    }
}

