/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser.antlr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class StringUtil {
    public static final String[] EMPTY = new String[0];
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String UNIX_LINE_SEPARATOR = "\n";

    public static String spaces(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static StringBuilder spaces(StringBuilder sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    public static String stripLeadingZeroes(String stripFrom) {
        return stripFrom.length() > 0 && stripFrom.charAt(0) == '0' ? StringUtil.stripLeadingZeroes(stripFrom.substring(1)) : stripFrom;
    }

    public static int countOccurrences(String str, char c) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String replaceUppercaseWithCharacter(String str, char ch) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append(ch);
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String capitalizeFirstLetter(String str) {
        if (str.length() > 0) {
            return StringUtil.replaceCharAt(str, 0, Character.toUpperCase(str.charAt(0)));
        }
        return str;
    }

    public static String uncapitalizeFirstLetter(String str) {
        if (str.length() > 0) {
            return StringUtil.replaceCharAt(str, 0, Character.toLowerCase(str.charAt(0)));
        }
        return str;
    }

    public static String replaceCharAt(String s, int pos, char c) {
        return s.substring(0, pos) + c + s.substring(pos + 1);
    }

    public static int computeLevenshteinDistance(String str1, String str2) {
        int l1 = Objects.requireNonNull(str1, "str1 is null").length();
        int l2 = Objects.requireNonNull(str2, "str2 is null").length();
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        return l1 > l2 ? StringUtil.computeLevenshteinDistance0(str2, l2, str1, l1) : StringUtil.computeLevenshteinDistance0(str1, l1, str2, l2);
    }

    public static String findMinimumLevenshteinDistanceErrorString(String word, Iterable<String> options, int maximumDistance, String tooManyMatches, int maximumMatches) {
        List<String> candidates = StringUtil.findMinimumLevenshteinDistance(word, options, maximumDistance);
        if (candidates.size() == 1) {
            return ", did you mean: " + candidates.iterator().next();
        }
        if (candidates.size() > 1 && candidates.size() <= maximumMatches) {
            return ", did you mean one of: " + candidates;
        }
        return tooManyMatches;
    }

    public static List<String> findMinimumLevenshteinDistance(String word, Iterable<String> options, int maximumDistance) {
        int currentMinimumDistance = Integer.MAX_VALUE;
        HashSet<String> tmp = new HashSet<String>();
        for (String str : Objects.requireNonNull(options, "options is null")) {
            int r = StringUtil.computeLevenshteinDistance(word, str);
            if (r > maximumDistance || r > currentMinimumDistance) continue;
            if (r < currentMinimumDistance) {
                tmp.clear();
                currentMinimumDistance = r;
            }
            tmp.add(str);
        }
        ArrayList<String> result = new ArrayList<String>(tmp);
        Collections.sort(result);
        return result;
    }

    private static int computeLevenshteinDistance0(String str1, int l1, String str2, int l2) {
        int i;
        int[] prev = new int[l1 + 1];
        int[] cost = new int[l1 + 1];
        for (i = 0; i <= l1; ++i) {
            prev[i] = i;
        }
        for (i = 1; i <= l2; ++i) {
            cost[0] = i;
            char t_j = str2.charAt(i - 1);
            for (int j = 1; j <= l1; ++j) {
                int c = str1.charAt(j - 1) == t_j ? 0 : 1;
                cost[j] = Math.min(Math.min(cost[j - 1] + 1, prev[j] + 1), prev[j - 1] + c);
            }
            int[] tmp = prev;
            prev = cost;
            cost = tmp;
        }
        return prev[l1];
    }
}

