/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser.antlr;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlLexer;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.MsdlLogger;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class AntlrFile {
    MsdlParser.CompilationUnitContext context;
    final ANTLRInputStream input;
    final MsdlLexer lexer;
    final MsdlLogger logger;
    final MsdlParser parser;
    final Path path;
    final CommonTokenStream tokenStream;

    public AntlrFile(Path path, MsdlLogger logger) throws IOException {
        this.path = path;
        this.input = new ANTLRInputStream(Files.newInputStream(path, new OpenOption[0]));
        this.lexer = new MsdlLexer((CharStream)this.input);
        this.tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser = new MsdlParser((TokenStream)this.tokenStream);
        this.logger = Objects.requireNonNull(logger);
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
        this.lexer.addErrorListener((ANTLRErrorListener)new VerboseListener());
        this.parser.addErrorListener((ANTLRErrorListener)new VerboseListener());
    }

    public AntlrFile(URL url, MsdlLogger logger) throws IOException {
        this.path = null;
        this.input = new ANTLRInputStream(url.openStream());
        this.lexer = new MsdlLexer((CharStream)this.input);
        this.tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser = new MsdlParser((TokenStream)this.tokenStream);
        this.logger = Objects.requireNonNull(logger);
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
        this.lexer.addErrorListener((ANTLRErrorListener)new VerboseListener());
        this.parser.addErrorListener((ANTLRErrorListener)new VerboseListener());
    }

    public MsdlParser.CompilationUnitContext getCompilationUnit() {
        MsdlParser.CompilationUnitContext context = this.context;
        return context == null ? (this.context = this.parser.compilationUnit()) : context;
    }

    public MsdlLexer getLexer() {
        return this.lexer;
    }

    public MsdlParser getParser() {
        return this.parser;
    }

    public Path getPath() {
        return this.path;
    }

    public CommonTokenStream getTokenStream() {
        return this.tokenStream;
    }

    class VerboseListener
    extends BaseErrorListener {
        VerboseListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            AntlrFile.this.logger.error(AntlrFile.this.path + ":[" + line + ":" + charPositionInLine + "] " + msg);
            if (recognizer instanceof Parser) {
                List stack = ((Parser)recognizer).getRuleInvocationStack();
                Collections.reverse(stack);
            }
        }
    }
}

