/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import net.maritimecloud.internal.msdl.parser.ParsedEndpoint;
import net.maritimecloud.internal.msdl.parser.ParsedEndpointFunction;
import net.maritimecloud.internal.msdl.parser.ParsedEndpointFunctionArgument;
import net.maritimecloud.internal.msdl.parser.ParsedEnum;
import net.maritimecloud.internal.msdl.parser.ParsedField;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.ParsedMessage;
import net.maritimecloud.internal.msdl.parser.ParsedType;
import net.maritimecloud.msdl.MsdlLogger;
import net.maritimecloud.msdl.model.BaseType;

class TypeResolver {
    final Collection<ParsedFile> files;
    final MsdlLogger logger;
    final Multimap<String, Object> types = ArrayListMultimap.create();

    TypeResolver(MsdlLogger logger, Collection<ParsedFile> files) {
        this.files = Objects.requireNonNull(files);
        this.logger = Objects.requireNonNull(logger);
    }

    void resolve() {
        for (ParsedFile f : this.files) {
            for (ParsedMessage parsedMessage : f.listOf(ParsedMessage.class)) {
                this.resolveMessage0(parsedMessage);
            }
            for (ParsedEnum parsedEnum : f.listOf(ParsedEnum.class)) {
                this.resolveEnum0(parsedEnum);
            }
        }
        for (ParsedFile f : this.files) {
            for (ParsedMessage parsedMessage : f.listOf(ParsedMessage.class)) {
                this.resolveMessage1(parsedMessage);
            }
        }
        for (ParsedFile f : this.files) {
            for (ParsedEndpoint parsedEndpoint : f.listOf(ParsedEndpoint.class)) {
                for (ParsedEndpointFunction fu : parsedEndpoint.endpointFunction.values()) {
                    if (fu.returnType != null) {
                        this.resolveType1(fu.returnType);
                    }
                    for (ParsedEndpointFunctionArgument s : fu.parametersByName.values()) {
                        this.resolveType1(s.type);
                    }
                }
            }
        }
    }

    private void resolveEnum0(ParsedEnum e) {
        this.types.put((Object)e.getName(), (Object)e);
    }

    private void resolveMessage0(ParsedMessage m) {
        this.types.put((Object)m.getName(), (Object)m);
    }

    private void resolveMessage1(ParsedMessage m) {
        for (ParsedField f : m.fieldsByTag.values()) {
            this.resolveType1(f.type);
        }
    }

    private void resolveType1(ParsedType t) {
        if (t.type == null) {
            String name = t.referenceName;
            Collection l = this.types.get((Object)name);
            if (l.size() == 0) {
                this.logger.error("Could not find type '" + name + "', Available types = " + this.types.keySet());
            } else if (l.size() > 1) {
                this.logger.error("Too many of types " + name);
            } else {
                Object o = l.iterator().next();
                t.messageOrEnum = o;
                t.type = o instanceof ParsedEnum ? BaseType.ENUM : BaseType.MESSAGE;
            }
        }
        for (ParsedType tt : t.arguments) {
            this.resolveType1(tt);
        }
    }
}

