/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.model.BaseType;
import net.maritimecloud.msdl.model.ListOrSetType;
import net.maritimecloud.msdl.model.MapType;
import net.maritimecloud.msdl.model.Type;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ParsedType {
    BaseType type;
    String referenceName;
    Object messageOrEnum;
    List<ParsedType> arguments = new ArrayList<ParsedType>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ParsedType parse(ParsedFile file, MsdlParser.TypeContext c) {
        if (c.primitiveType() != null) {
            MsdlParser.PrimitiveTypeContext ptc = c.primitiveType();
            int t = ptc.start.getType();
            if (t == 6) {
                this.type = BaseType.INT;
                return this;
            } else if (t == 7) {
                this.type = BaseType.INT64;
                return this;
            } else if (t == 9) {
                this.type = BaseType.FLOAT;
                return this;
            } else if (t == 10) {
                this.type = BaseType.DOUBLE;
                return this;
            } else if (t == 12) {
                this.type = BaseType.BOOLEAN;
                return this;
            } else if (t == 13) {
                this.type = BaseType.BINARY;
                return this;
            } else if (t == 14) {
                this.type = BaseType.TEXT;
                return this;
            } else if (t == 16) {
                this.type = BaseType.POSITION;
                return this;
            } else if (t == 17) {
                this.type = BaseType.POSITION_TIME;
                return this;
            } else if (t == 15) {
                this.type = BaseType.TIMESTAMP;
                return this;
            } else if (t == 8) {
                this.type = BaseType.VARINT;
                return this;
            } else {
                if (t != 11) throw new Error("Unknown type " + t);
                this.type = BaseType.DECIMAL;
            }
            return this;
        } else if (c.complexType() != null) {
            MsdlParser.ComplexTypeContext ctc = c.complexType();
            int t = ((TerminalNode)ctc.getChild(0)).getSymbol().getType();
            if (t == 18) {
                this.type = BaseType.LIST;
                ParsedType element = new ParsedType().parse(file, ctc.type(0));
                this.arguments.add(element);
                return this;
            } else if (t == 19) {
                this.type = BaseType.SET;
                ParsedType element = new ParsedType().parse(file, ctc.type(0));
                this.arguments.add(element);
                return this;
            } else {
                if (t != 20) throw new Error("Unknown type " + t);
                this.type = BaseType.MAP;
                ParsedType key = new ParsedType().parse(file, ctc.type(0));
                ParsedType value = new ParsedType().parse(file, ctc.type(1));
                this.arguments.add(key);
                this.arguments.add(value);
            }
            return this;
        } else {
            this.reference(file, c.qualifiedName());
        }
        return this;
    }

    private void reference(ParsedFile file, MsdlParser.QualifiedNameContext con) {
        String name = con.Identifier().get(0).getText();
        if (name.equals("String")) {
            file.error(con, "'String' is an illegal name, did you mean 'text'");
        } else if (name.equals("long")) {
            file.error(con, "'long' is an illegal name, did you mean 'int64'");
        } else if (name.equals("Binary")) {
            file.error(con, "'Binary' is an illegal name, did you mean 'binary'");
        } else {
            this.referenceName = name;
        }
    }

    Type toType() {
        if (this.type.isPrimitive()) {
            return new PrimitiveType(this.type);
        }
        if (this.type == BaseType.LIST) {
            Type anyType = this.arguments.get(0).toType();
            return new ListTypeImpl(anyType);
        }
        if (this.type == BaseType.SET) {
            Type anyType = this.arguments.get(0).toType();
            return new SetTypeImpl(anyType);
        }
        if (this.type == BaseType.MAP) {
            Type keyType = this.arguments.get(0).toType();
            Type valueType = this.arguments.get(1).toType();
            return new MapTypeImpl(keyType, valueType);
        }
        return Objects.requireNonNull((Type)this.messageOrEnum);
    }

    static class PrimitiveType
    implements Type {
        BaseType type;

        PrimitiveType(BaseType type) {
            this.type = type;
        }

        @Override
        public BaseType getBaseType() {
            return this.type;
        }
    }

    static class ListTypeImpl
    implements ListOrSetType {
        final Type type;

        ListTypeImpl(Type type) {
            this.type = Objects.requireNonNull(type);
        }

        @Override
        public BaseType getBaseType() {
            return BaseType.LIST;
        }

        @Override
        public Type getElementType() {
            return this.type;
        }
    }

    static class SetTypeImpl
    implements ListOrSetType {
        final Type type;

        SetTypeImpl(Type type) {
            this.type = Objects.requireNonNull(type);
        }

        @Override
        public BaseType getBaseType() {
            return BaseType.SET;
        }

        @Override
        public Type getElementType() {
            return this.type;
        }
    }

    static class MapTypeImpl
    implements MapType {
        final Type key;
        final Type value;

        MapTypeImpl(Type key, Type value) {
            this.key = Objects.requireNonNull(key);
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public BaseType getBaseType() {
            return BaseType.MAP;
        }

        @Override
        public Type getKeyType() {
            return this.key;
        }

        @Override
        public Type getValueType() {
            return this.value;
        }
    }
}

