/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.maritimecloud.internal.msdl.parser.ImportResolver;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.TypeResolver;
import net.maritimecloud.internal.msdl.parser.antlr.AntlrFile;
import net.maritimecloud.msdl.MsdlLogger;
import net.maritimecloud.msdl.model.MsdlFile;
import net.maritimecloud.msdl.model.Project;

public class ParsedProject {
    final Map<String, Path> sourceFiles;
    final ImportResolver importResolver;
    final MsdlLogger logger;
    final AtomicInteger errorCounter = new AtomicInteger();
    final Map<String, ParsedFile> files = new TreeMap<String, ParsedFile>();

    public ParsedProject(Map<String, Path> sourceFiles, List<Path> directories, MsdlLogger logger) {
        this.sourceFiles = Objects.requireNonNull(sourceFiles);
        this.importResolver = new ImportResolver(directories, logger);
        this.logger = MsdlLogger.errorCountingLogger(logger, this.errorCounter);
    }

    public Project parse() {
        try {
            return this.parse0();
        }
        catch (Exception e) {
            this.logger.error("Failed to parse files " + e.getMessage(), e);
            return null;
        }
    }

    Project parse0() throws Exception {
        for (Map.Entry<String, Path> e : this.sourceFiles.entrySet()) {
            ParsedFile file = this.parseFile(e.getValue());
            this.files.put(e.getKey(), file);
            this.importResolver.resolvedDependency.put(e.getKey(), file);
        }
        if (this.errorCounter.get() > 0) {
            return null;
        }
        this.importResolver.resolveAll(this, this.files.values());
        if (this.errorCounter.get() > 0) {
            return null;
        }
        new TypeResolver(this.logger, this.importResolver.resolvedDependency.values()).resolve();
        if (this.errorCounter.get() > 0) {
            return null;
        }
        return new ProjectImpl(new TreeMap<String, MsdlFile>(this.files));
    }

    ParsedFile parseFile(Path p) throws IOException {
        ParsedFile f = new ParsedFile(this, new AntlrFile(p, this.logger));
        f.parse();
        return f;
    }

    ParsedFile parseFile(URL p) throws IOException {
        ParsedFile f = new ParsedFile(this, new AntlrFile(p, this.logger));
        f.parse();
        return f;
    }

    static class ProjectImpl
    implements Project {
        final Map<String, MsdlFile> files;

        ProjectImpl(Map<String, MsdlFile> files) {
            this.files = Collections.unmodifiableMap(files);
        }

        @Override
        public Iterator<MsdlFile> iterator() {
            return this.files.values().iterator();
        }

        @Override
        public Map<String, MsdlFile> getFiles() {
            return this.files;
        }
    }
}

