/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.maritimecloud.internal.msdl.parser.AbstractContainer;
import net.maritimecloud.internal.msdl.parser.AnnotationContainer;
import net.maritimecloud.internal.msdl.parser.ParsedEnum;
import net.maritimecloud.internal.msdl.parser.ParsedField;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.model.BaseType;
import net.maritimecloud.msdl.model.FieldOrParameter;
import net.maritimecloud.msdl.model.MessageDeclaration;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ParsedMessage
extends AbstractContainer
implements MessageDeclaration {
    final LinkedHashMap<Integer, ParsedField> fieldsByTag = new LinkedHashMap();
    final LinkedHashMap<String, ParsedField> fieldsByName = new LinkedHashMap();
    final List<ParsedEnum> enums = new ArrayList<ParsedEnum>();
    final List<ParsedEnum> messages = new ArrayList<ParsedEnum>();

    ParsedMessage(ParsedFile file, AnnotationContainer ac) {
        super(file, ac);
    }

    ParsedMessage parse(MsdlParser.MessageDeclarationContext c) {
        this.parse(c.Identifier(), c.fields());
        return this;
    }

    ParsedMessage parse(TerminalNode identifier, MsdlParser.FieldsContext fields) {
        this.setName(identifier.getText());
        for (MsdlParser.FieldContext ec : fields.field()) {
            ParsedField pf = ParsedField.create(this, ec);
            if (pf == null) continue;
            if (this.fieldsByName.containsKey(pf.getName())) {
                this.file.error(ec, "A field named '" + pf.getName() + "' is defined multiple times in the message '" + this.getName() + "'");
                continue;
            }
            if (this.fieldsByTag.containsKey(pf.getTag())) {
                this.file.error(ec, "Multiple fields with the same tag '" + pf.getTag() + "' is defined in the message '" + pf.name + "'");
                continue;
            }
            this.fieldsByName.put(pf.getName(), pf);
            this.fieldsByTag.put(pf.getTag(), pf);
        }
        return this;
    }

    @Override
    public BaseType getBaseType() {
        return BaseType.MESSAGE;
    }

    @Override
    public final List<FieldOrParameter> getFields() {
        return Collections.unmodifiableList(new ArrayList<ParsedField>(this.fieldsByTag.values()));
    }

    @Override
    public final Iterator<FieldOrParameter> iterator() {
        return this.getFields().iterator();
    }
}

