/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.maritimecloud.internal.msdl.parser.AbstractContainer;
import net.maritimecloud.internal.msdl.parser.AnnotationContainer;
import net.maritimecloud.internal.msdl.parser.ParsedBroadcastMessage;
import net.maritimecloud.internal.msdl.parser.ParsedEndpoint;
import net.maritimecloud.internal.msdl.parser.ParsedEnum;
import net.maritimecloud.internal.msdl.parser.ParsedMessage;
import net.maritimecloud.internal.msdl.parser.ParsedProject;
import net.maritimecloud.internal.msdl.parser.antlr.AntlrFile;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.model.BroadcastMessageDeclaration;
import net.maritimecloud.msdl.model.EndpointDefinition;
import net.maritimecloud.msdl.model.EnumDeclaration;
import net.maritimecloud.msdl.model.MessageDeclaration;
import net.maritimecloud.msdl.model.MsdlFile;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

class ParsedFile
implements MsdlFile {
    final AntlrFile antlrFile;
    final ArrayList<String> imports = new ArrayList();
    String namespace;
    final ParsedProject project;
    final ArrayList<ParsedFile> resolvedImports = new ArrayList();
    final List<AbstractContainer> containers = new ArrayList<AbstractContainer>();

    ParsedFile(ParsedProject project, AntlrFile antlrFile) {
        this.antlrFile = Objects.requireNonNull(antlrFile);
        this.project = Objects.requireNonNull(project);
    }

    void error(ParserRuleContext context, String msg) {
        String st = this.antlrFile.getPath() + ":[" + context.getStart().getLine() + ":" + context.getStart().getCharPositionInLine() + "] ";
        st = st + msg;
        this.project.logger.error(st);
    }

    @Override
    public List<BroadcastMessageDeclaration> getBroadcasts() {
        return this.listOf(BroadcastMessageDeclaration.class);
    }

    <T> List<T> listOf(Class<T> type) {
        ArrayList<AbstractContainer> result = new ArrayList<AbstractContainer>();
        for (AbstractContainer o : this.containers) {
            if (!type.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return result;
    }

    @Override
    public List<EndpointDefinition> getEndpoints() {
        return this.listOf(EndpointDefinition.class);
    }

    @Override
    public List<EnumDeclaration> getEnums() {
        return this.listOf(EnumDeclaration.class);
    }

    @Override
    public List<MessageDeclaration> getMessages() {
        List<MessageDeclaration> result = this.listOf(MessageDeclaration.class);
        Iterator<MessageDeclaration> iterator = result.iterator();
        while (iterator.hasNext()) {
            MessageDeclaration d = iterator.next();
            if (!(d instanceof BroadcastMessageDeclaration)) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    void parse() {
        this.parseNamespace();
        this.parseImports();
        this.parseTypes();
    }

    private void parseImports() {
        for (MsdlParser.ImportDeclarationContext importContext : this.antlrFile.getCompilationUnit().importDeclaration()) {
            String p = importContext.getChild(1).getText();
            p = p.substring(1, p.length() - 1);
            this.imports.add(p);
        }
    }

    private void parseNamespace() {
        MsdlParser.NamespaceDeclarationContext namespaceContext = this.antlrFile.getCompilationUnit().namespaceDeclaration();
        if (namespaceContext != null) {
            this.namespace = namespaceContext.getChild(1).getText();
        }
    }

    private void parseTypes() {
        for (MsdlParser.TypeDeclarationContext tdc : this.antlrFile.getCompilationUnit().typeDeclaration()) {
            AnnotationContainer ac = new AnnotationContainer(this).parse(tdc);
            ParseTree child = tdc.getChild(tdc.getChildCount() - 1);
            if (child instanceof MsdlParser.EnumDeclarationContext) {
                this.containers.add(new ParsedEnum(this, ac).parse((MsdlParser.EnumDeclarationContext)child));
                continue;
            }
            if (child instanceof MsdlParser.MessageDeclarationContext) {
                this.containers.add(new ParsedMessage(this, ac).parse((MsdlParser.MessageDeclarationContext)child));
                continue;
            }
            if (child instanceof MsdlParser.BroadcastDeclarationContext) {
                this.containers.add(new ParsedBroadcastMessage(this, ac).parse((MsdlParser.BroadcastDeclarationContext)child));
                continue;
            }
            if (!(child instanceof MsdlParser.EndpointDeclarationContext)) continue;
            this.containers.add(new ParsedEndpoint(this, ac).parse((MsdlParser.EndpointDeclarationContext)child));
        }
    }

    public String toString() {
        return this.antlrFile.getPath().toString();
    }

    void warn(ParserRuleContext context, String msg) {
    }
}

