/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.maritimecloud.internal.msdl.parser.AbstractContainer;
import net.maritimecloud.internal.msdl.parser.AnnotationContainer;
import net.maritimecloud.internal.msdl.parser.Checks;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.model.BaseType;
import net.maritimecloud.msdl.model.EnumDeclaration;

public class ParsedEnum
extends AbstractContainer
implements EnumDeclaration {
    private final LinkedHashMap<Integer, EnumDeclaration.Constant> byId = new LinkedHashMap();
    private final LinkedHashMap<String, EnumDeclaration.Constant> byName = new LinkedHashMap();

    ParsedEnum(ParsedFile file, AnnotationContainer ac) {
        super(file, ac);
    }

    ParsedEnum parse(MsdlParser.EnumDeclarationContext c) {
        this.setName(c.Identifier().getText());
        for (MsdlParser.EnumTypeDeclarationContext ec : c.enumBody().enumTypeDeclaration()) {
            String name = this.parseEnumValueName(ec);
            Integer value = this.parseEnumValueIntValue(ec);
            if (name == null || value == null) continue;
            if (this.byName.containsKey(name)) {
                this.file.error(ec, "variable '" + value + "' is defined multiple times in the enum '" + name + "'");
                continue;
            }
            if (this.byId.containsKey(value)) {
                this.file.error(ec, "enum value '" + value + "' is used for multiple variables in the enum '" + name + "'");
                continue;
            }
            EnumValueImpl impl = new EnumValueImpl(name, value);
            this.byName.put(name, impl);
            this.byId.put(value, impl);
        }
        return this;
    }

    private String parseEnumValueName(MsdlParser.EnumTypeDeclarationContext c) {
        String name = c.Identifier().getText();
        if (Checks.checkFirstUpper(this.file, c, "An enum value name", name) && Checks.checkAsciiUpperLowercase(this.file, c, "An enum value name", name)) {
            return name;
        }
        return null;
    }

    private Integer parseEnumValueIntValue(MsdlParser.EnumTypeDeclarationContext c) {
        String value = c.Digits().getText();
        try {
            int i = Integer.parseInt(value);
            if (i > 0) {
                return i;
            }
            this.file.error(c, "An enum value must be non-negative, was '" + value + "'");
        }
        catch (NumberFormatException e) {
            this.file.error(c, "An enum value must be less than 2147483647, was " + value);
        }
        return null;
    }

    @Override
    public BaseType getBaseType() {
        return BaseType.ENUM;
    }

    @Override
    public List<EnumDeclaration.Constant> getConstants() {
        return Collections.unmodifiableList(new ArrayList<EnumDeclaration.Constant>(this.byId.values()));
    }

    @Override
    public Iterator<EnumDeclaration.Constant> iterator() {
        return this.getConstants().iterator();
    }

    static class EnumValueImpl
    implements EnumDeclaration.Constant {
        private final String name;
        private final int value;

        EnumValueImpl(String name, int value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

