/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.maritimecloud.internal.msdl.parser.MsdlComment;
import net.maritimecloud.internal.msdl.parser.ParsedEndpoint;
import net.maritimecloud.internal.msdl.parser.ParsedEndpointFunctionArgument;
import net.maritimecloud.internal.msdl.parser.ParsedType;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.model.CommentDeclaration;
import net.maritimecloud.msdl.model.EndpointMethod;
import net.maritimecloud.msdl.model.FieldOrParameter;
import net.maritimecloud.msdl.model.Type;

public class ParsedEndpointFunction
implements EndpointMethod {
    final LinkedHashMap<Integer, ParsedEndpointFunctionArgument> parametersByTag = new LinkedHashMap();
    final LinkedHashMap<String, ParsedEndpointFunctionArgument> parametersByName = new LinkedHashMap();
    MsdlComment comment;
    final ParsedEndpoint endpoint;
    String name;
    ParsedType returnType;
    Type publicReturnType;

    ParsedEndpointFunction(ParsedEndpoint endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CommentDeclaration getComment() {
        return this.comment;
    }

    @Override
    public Type getReturnType() {
        if (this.returnType == null) {
            return null;
        }
        if (this.publicReturnType == null) {
            this.publicReturnType = this.returnType.toType();
            return this.publicReturnType;
        }
        return this.publicReturnType;
    }

    void parse(MsdlParser.FunctionContext c) {
        this.name = c.Identifier().getText();
        MsdlParser.ReturnTypeContext type = c.returnType();
        if (type.type() != null) {
            this.returnType = new ParsedType();
            this.returnType.parse(this.endpoint.file, type.type());
        }
        for (MsdlParser.FunctionArgumentContext ec : c.functionArgument()) {
            ParsedEndpointFunctionArgument pf = ParsedEndpointFunctionArgument.create(this, ec);
            if (pf == null) continue;
            if (this.parametersByName.containsKey(pf.getName())) {
                this.endpoint.file.error(ec, "A field named '" + pf.getName() + "' is defined multiple times in the message '" + this.getName() + "'");
                continue;
            }
            if (this.parametersByTag.containsKey(pf.getTag())) {
                this.endpoint.file.error(ec, "Multiple fields with the same tag '" + pf.getTag() + "' is defined in the message '" + pf.name + "'");
                continue;
            }
            this.parametersByName.put(pf.getName(), pf);
            this.parametersByTag.put(pf.getTag(), pf);
        }
    }

    @Override
    public List<FieldOrParameter> getParameters() {
        return new ArrayList<FieldOrParameter>(this.parametersByName.values());
    }
}

