/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.maritimecloud.internal.msdl.parser.AbstractContainer;
import net.maritimecloud.internal.msdl.parser.AnnotationContainer;
import net.maritimecloud.internal.msdl.parser.ParsedEndpointFunction;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.model.EndpointDefinition;
import net.maritimecloud.msdl.model.EndpointMethod;

public class ParsedEndpoint
extends AbstractContainer
implements EndpointDefinition {
    final LinkedHashMap<String, ParsedEndpointFunction> endpointFunction = new LinkedHashMap();

    ParsedEndpoint(ParsedFile file, AnnotationContainer ac) {
        super(file, ac);
    }

    ParsedEndpoint parse(MsdlParser.EndpointDeclarationContext c) {
        this.setName(c.Identifier().getText());
        for (MsdlParser.FunctionContext ec : c.function()) {
            ParsedEndpointFunction pf = new ParsedEndpointFunction(this);
            pf.parse(ec);
            if (pf == null) continue;
            if (this.endpointFunction.containsKey(pf.name)) {
                this.file.error(ec, "variable name '" + pf.name + "' is defined multiple times in the message '" + pf.name + "'");
                continue;
            }
            this.endpointFunction.put(pf.name, pf);
        }
        return this;
    }

    @Override
    public List<EndpointMethod> getFunctions() {
        return Collections.unmodifiableList(new ArrayList<ParsedEndpointFunction>(this.endpointFunction.values()));
    }
}

