/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.ParsedProject;
import net.maritimecloud.msdl.MsdlLogger;
import net.maritimecloud.msdl.MsdlPluginException;

class ImportResolver
implements Iterable<ParsedFile> {
    Map<String, Path> dependencies;
    Map<String, ParsedFile> resolvedDependency = new LinkedHashMap<String, ParsedFile>();
    final List<Path> directories;
    final MsdlLogger logger;

    ImportResolver(List<Path> directories, MsdlLogger logger) {
        this.directories = Objects.requireNonNull(directories);
        this.logger = Objects.requireNonNull(logger);
    }

    ParsedFile resolveImport(ParsedProject project, String name) throws IOException {
        Path p;
        ParsedFile f = this.resolvedDependency.get(name);
        if (f != null) {
            return f;
        }
        if (this.dependencies == null) {
            this.dependencies = new LinkedHashMap<String, Path>();
            for (final Path root : this.directories) {
                this.logger.debug("Looking for .msdl dependencies in " + root);
                SimpleFileVisitor<Path> sfv = new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".msdl")) {
                            String p = root.relativize(file).toString();
                            if (ImportResolver.this.dependencies.containsKey(p)) {
                                ImportResolver.this.logger.warn("Multiple files named '" + p + " existed, ignore second file, first = " + ImportResolver.this.dependencies.get(p) + ", second = " + file);
                            } else {
                                ImportResolver.this.dependencies.put(p, file);
                            }
                        }
                        return super.visitFile(file, attrs);
                    }
                };
                try {
                    Files.walkFileTree(root, (FileVisitor<? super Path>)sfv);
                }
                catch (IOException e) {
                    this.logger.error("Failed to process dependencies", e);
                    throw new MsdlPluginException("Failed to process dependencies", e);
                }
            }
        }
        if ((p = this.dependencies.get(name)) == null) {
            Enumeration<URL> resources = ImportResolver.class.getClassLoader().getResources(name);
            ArrayList<URL> l = Collections.list(resources);
            if (l.isEmpty()) {
                this.logger.error("Could not find import " + name);
            } else if (l.size() == 1) {
                f = project.parseFile((URL)l.get(0));
                if (l.size() > 0) {
                    this.logger.warn("Multiple files named '" + p + " existed on the classpath, will use first file: " + l.get(0));
                }
            }
        } else {
            f = project.parseFile(p);
        }
        if (f != null) {
            this.resolvedDependency.put(name, f);
        }
        return f;
    }

    void resolveAll(ParsedProject project, Collection<ParsedFile> initial) throws IOException {
        LinkedHashSet<ParsedFile> allFiles = new LinkedHashSet<ParsedFile>(initial);
        LinkedList<ParsedFile> unImportedFiles = new LinkedList<ParsedFile>(initial);
        while (!unImportedFiles.isEmpty()) {
            ParsedFile pf = unImportedFiles.poll();
            for (String importLocation : pf.imports) {
                ParsedFile imp = this.resolveImport(project, importLocation);
                if (imp == null) continue;
                if (!allFiles.contains(imp)) {
                    allFiles.add(imp);
                    unImportedFiles.add(imp);
                }
                pf.resolvedImports.add(imp);
            }
        }
    }

    @Override
    public Iterator<ParsedFile> iterator() {
        return this.resolvedDependency.values().iterator();
    }
}

