/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import net.maritimecloud.internal.msdl.parser.ParsedFile;
import org.antlr.v4.runtime.ParserRuleContext;

public class Checks {
    public static boolean checkFirstLower(ParsedFile file, ParserRuleContext c, String prefix, String name) {
        if (name == null || name.length() == 0 || !Checks.isAsciiAlphaLower(name.charAt(0))) {
            file.error(c, prefix + ", must start with an lowercase ascii character (a-z), was '" + name + "'");
            return false;
        }
        return true;
    }

    public static boolean checkFirstUpper(ParsedFile file, ParserRuleContext c, String prefix, String name) {
        if (name == null || name.length() == 0 || !Checks.isAsciiAlphaUpper(name.charAt(0))) {
            file.error(c, prefix + ", must start with an uppercase ascii character (A-Z), was '" + name + "'");
            return false;
        }
        return true;
    }

    public static boolean checkAsciiNumber(ParsedFile file, ParserRuleContext c, String prefix, String name) {
        if (!name.matches("[A-Z][a-zA-Z0-9_]*")) {
            file.error(c, prefix + ", must consists only of ascii characters (a-zA-Z), numbers (1-9) and underscore (_) , was '" + name + "'");
            return false;
        }
        return true;
    }

    public static boolean checkAsciiUpperLowercase(ParsedFile file, ParserRuleContext c, String prefix, String name) {
        if (!name.matches("[A-Z][A-Z0-9_]*")) {
            file.error(c, prefix + ", must consists only of uppercase ascii characters (A-Z), numbers (1-9) and underscore (_) , was '" + name + "'");
            return false;
        }
        return true;
    }

    private static boolean isAsciiAlphaLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    private static boolean isAsciiAlphaUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }
}

