/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class AnnotationContainer {
    private final Map<String, Anno> annotations = new LinkedHashMap<String, Anno>();
    final ParsedFile file;

    AnnotationContainer(ParsedFile file) {
        this.file = Objects.requireNonNull(file);
    }

    @SafeVarargs
    final void addAnnotation(String name, Map.Entry<String, Object> ... pairs) {
        this.annotations.put(name, new Anno(name, pairs));
    }

    <T extends Annotation> T getAnnotation(Class<T> type) {
        Anno anno = this.annotations.get(type.getSimpleName());
        if (anno == null) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(AnnotationContainer.class.getClassLoader(), new Class[]{type}, (InvocationHandler)anno));
    }

    boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.annotations.containsKey(annotation.getSimpleName());
    }

    AnnotationContainer parse(ParserRuleContext c) {
        for (ParseTree pt : c.children) {
            Anno anno;
            if (!(pt instanceof MsdlParser.AnnotationContext)) continue;
            MsdlParser.AnnotationContext ac = (MsdlParser.AnnotationContext)pt;
            String name = ac.annotationName().qualifiedName().getText();
            MsdlParser.ElementValueContext ev = ac.elementValue();
            if (ev != null) {
                ArrayList<String> list = new ArrayList<String>();
                if (ev.StringLiteral() != null) {
                    String text = ev.StringLiteral().getText();
                    text = text.replace("\"", "");
                    list.add(text);
                } else {
                    MsdlParser.ElementValueArrayInitializerContext ec = ev.elementValueArrayInitializer();
                    for (int i = 0; i < ec.children.size(); ++i) {
                        MsdlParser.ElementValueContext evc = ec.elementValue(i);
                        if (evc == null) continue;
                        String text = evc.StringLiteral().getText();
                        text = text.replace("\"", "");
                        list.add(text);
                    }
                }
                anno = new Anno(name, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<String, String[]>("value", list.toArray(new String[0]))});
            } else {
                anno = new Anno(name, new Map.Entry[0]);
            }
            this.annotations.put(name, anno);
        }
        return this;
    }

    static class Anno
    implements InvocationHandler {
        String name;
        Map.Entry<String, Object>[] pairs;

        Anno(String name, Map.Entry<String, Object>[] pairs) {
            this.name = name;
            this.pairs = pairs;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (Map.Entry<String, Object> e : this.pairs) {
                if (!e.getKey().equals(method.getName())) continue;
                if (method.getReturnType().equals(String[].class)) {
                    return e.getValue();
                }
                return ((String[])e.getValue())[0];
            }
            return null;
        }
    }
}

