/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.msdl.parser;

import net.maritimecloud.internal.msdl.parser.MsdlComment;
import net.maritimecloud.internal.msdl.parser.ParsedField;
import net.maritimecloud.internal.msdl.parser.ParsedFile;
import net.maritimecloud.internal.msdl.parser.ParsedType;
import net.maritimecloud.internal.msdl.parser.antlr.MsdlParser;
import net.maritimecloud.msdl.model.CommentDeclaration;
import net.maritimecloud.msdl.model.FieldOrParameter;
import net.maritimecloud.msdl.model.Type;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AbstractFieldOrArgument
implements FieldOrParameter {
    private MsdlComment comment;
    final ParsedFile file;
    private Integer tag;
    String name;
    Type publicType;
    ParsedType type;

    AbstractFieldOrArgument(ParsedFile file) {
        this.file = file;
    }

    @Override
    public final CommentDeclaration getComment() {
        return this.comment;
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    private String n() {
        return this instanceof ParsedField ? " field" : " parameter";
    }

    @Override
    public final Type getType() {
        if (this.publicType == null) {
            this.publicType = this.type.toType();
            return this.publicType;
        }
        return this.publicType;
    }

    AbstractFieldOrArgument parse(ParserRuleContext c, TerminalNode nameReader, TerminalNode tagReader, MsdlParser.TypeContext type) {
        this.comment = MsdlComment.parseComments((BufferedTokenStream)this.file.antlrFile.getTokenStream(), c);
        this.parseName(c, nameReader);
        this.parseTag(c, tagReader);
        this.type = new ParsedType();
        this.type.parse(this.file, type);
        return this;
    }

    void parseName(ParserRuleContext c, TerminalNode n) {
        this.name = n.getText();
    }

    void parseTag(ParserRuleContext c, TerminalNode n) {
        String value = n.getText();
        try {
            int i = Integer.parseInt(value);
            if (i >= 0) {
                this.tag = i;
            } else {
                this.file.error(c, "A" + this.n() + " value must be non-negative, was '" + value + "'");
            }
        }
        catch (NumberFormatException e) {
            this.file.error(c, "A" + this.n() + " value must be less than " + Integer.MAX_VALUE + ", was " + value);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }
}

