/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.units;

public enum SpeedUnit {
    KILOMETERS_PER_HOUR{

        @Override
        public double toKilometersPerHour(double speed) {
            return speed;
        }

        @Override
        public double toKnots(double speed) {
            return speed / 1852.0 * 1000.0;
        }

        @Override
        public double toMetersPerSecond(double speed) {
            return speed / 3.6;
        }

        @Override
        public double toMilesPerHour(double speed) {
            return speed / 1609.344 * 1000.0;
        }
    }
    ,
    KNOTS{

        @Override
        public double toKilometersPerHour(double speed) {
            return speed * 1852.0 / 1000.0;
        }

        @Override
        public double toKnots(double speed) {
            return speed;
        }

        @Override
        public double toMetersPerSecond(double speed) {
            return speed * 1852.0 / 3600.0;
        }

        @Override
        public double toMilesPerHour(double speed) {
            return speed / 1609.344 * 1852.0;
        }
    }
    ,
    METERS_PER_SECOND{

        @Override
        public double toKilometersPerHour(double speed) {
            return speed * 3.6;
        }

        @Override
        public double toKnots(double speed) {
            return speed / 1852.0 * 3600.0;
        }

        @Override
        public double toMetersPerSecond(double speed) {
            return speed;
        }

        @Override
        public double toMilesPerHour(double speed) {
            return speed / 1609.344 * 3600.0;
        }
    }
    ,
    MILES_PER_HOUR{

        @Override
        public double toKilometersPerHour(double speed) {
            return speed * 1609.344 / 1000.0;
        }

        @Override
        public double toKnots(double speed) {
            return speed * 1609.344 / 1852.0;
        }

        @Override
        public double toMetersPerSecond(double speed) {
            return speed * 1609.344 / 3600.0;
        }

        @Override
        public double toMilesPerHour(double speed) {
            return speed;
        }
    };


    public abstract double toKilometersPerHour(double var1);

    public abstract double toKnots(double var1);

    public abstract double toMetersPerSecond(double var1);

    public abstract double toMilesPerHour(double var1);
}

