/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.util.Random;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.geometry.Area;
import net.maritimecloud.util.geometry.Circle;
import net.maritimecloud.util.geometry.Position;

public final class Rectangle
extends Area {
    public static final Rectangle ALL = new Rectangle(90.0, -180.0, -90.0, 180.0);
    public static final MessageSerializer<Rectangle> SERIALIZER = new MessageSerializer<Rectangle>(){

        @Override
        public Rectangle read(MessageReader reader) throws IOException {
            double topLeftLatitude = reader.readDouble(1, "topLeftLatitude");
            double topLeftLongitude = reader.readDouble(2, "topLeftLongitude");
            double bottomRightLatitude = reader.readDouble(3, "bottomRightLatitude");
            double bottomRightLongitude = reader.readDouble(4, "bottomRightLongitude");
            return Rectangle.create(topLeftLatitude, topLeftLongitude, bottomRightLatitude, bottomRightLongitude);
        }

        @Override
        public void write(Rectangle message, MessageWriter w) throws IOException {
            w.writeDouble(1, "topLeftLatitude", message.getTopLeftLatitude());
            w.writeDouble(2, "topLeftLongitude", message.getTopLeftLongitude());
            w.writeDouble(3, "bottomRightLatitude", message.getBottomRightLatitude());
            w.writeDouble(4, "bottomRightLongitude", message.getBottomRightLongitude());
        }
    };
    private static final long serialVersionUID = 1L;
    final double bottomRightLatitude;
    final double bottomRightLongitude;
    final double topLeftLatitude;
    final double topLeftLongitude;

    Rectangle(double topLeftLatitude, double topLeftLongitude, double bottomRightLatitude, double bottomRightLongitude) {
        this.topLeftLatitude = Position.verifyLatitude(topLeftLatitude);
        this.topLeftLongitude = Position.verifyLongitude(topLeftLongitude);
        this.bottomRightLatitude = Position.verifyLatitude(bottomRightLatitude);
        this.bottomRightLongitude = Position.verifyLongitude(bottomRightLongitude);
    }

    public boolean contains(double latitude, double longitude) {
        return this.containsLatitude(latitude) && this.containsLongitude(longitude);
    }

    @Override
    public boolean contains(Position position) {
        return this.contains(position.getLatitude(), position.getLongitude());
    }

    private boolean containsLatitude(double latitude) {
        if (this.topLeftLatitude >= this.bottomRightLatitude) {
            return this.bottomRightLatitude <= latitude && latitude <= this.topLeftLatitude;
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private boolean containsLongitude(double longitude) {
        if (this.topLeftLongitude <= this.bottomRightLongitude) {
            return this.topLeftLongitude <= longitude && longitude <= this.bottomRightLongitude;
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Rectangle && this.equals((Rectangle)obj);
    }

    private boolean equals(Rectangle that) {
        return this.topLeftLatitude == that.topLeftLatitude && this.topLeftLongitude == that.topLeftLongitude && this.bottomRightLatitude == that.bottomRightLatitude && this.bottomRightLongitude == that.bottomRightLongitude;
    }

    public Position getBottomRight() {
        return Position.create(this.getBottomRightLatitude(), this.getBottomRightLongitude());
    }

    public Position getBottomLeft() {
        return Position.create(this.getBottomRightLatitude(), this.getTopLeftLongitude());
    }

    public double getBottomRightLatitude() {
        return this.bottomRightLatitude;
    }

    public double getBottomRightLongitude() {
        return this.bottomRightLongitude;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this;
    }

    @Override
    public Position getRandomPosition(Random r) {
        if (!(this.topLeftLatitude >= this.bottomRightLatitude)) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        double latitude = Area.nextDouble(r, this.bottomRightLatitude, this.topLeftLatitude);
        if (!(this.topLeftLongitude <= this.bottomRightLongitude)) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        double longitude = Area.nextDouble(r, this.topLeftLongitude, this.bottomRightLongitude);
        return Position.create(latitude, longitude);
    }

    public Position getTopLeft() {
        return Position.create(this.getTopLeftLatitude(), this.getTopLeftLongitude());
    }

    public Position getTopRight() {
        return Position.create(this.getTopLeftLatitude(), this.getBottomRightLongitude());
    }

    public double getTopLeftLatitude() {
        return this.topLeftLatitude;
    }

    public double getTopLeftLongitude() {
        return this.topLeftLongitude;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + Double.hashCode(this.topLeftLatitude);
        result = 37 * result + Double.hashCode(this.topLeftLongitude);
        result = 37 * result + Double.hashCode(this.bottomRightLatitude);
        result = 37 * result + Double.hashCode(this.bottomRightLongitude);
        return result;
    }

    @Override
    public Rectangle immutable() {
        return this;
    }

    @Override
    public boolean intersects(Area other) {
        if (other instanceof Circle) {
            return this.intersects((Circle)other);
        }
        if (other instanceof Rectangle) {
            return this.intersects((Rectangle)other);
        }
        throw new UnsupportedOperationException("Only circles and Rectangle supported");
    }

    public boolean intersects(Circle other) {
        if (this.contains(other.getCenter())) {
            return true;
        }
        Position topLeft = this.getTopLeft();
        Position topRight = this.getTopRight();
        Position bottomLeft = this.getBottomLeft();
        Position bottomRight = this.getBottomRight();
        return other.intersects(topLeft, topRight) || other.intersects(topRight, bottomLeft) || other.intersects(topLeft, bottomLeft) || other.intersects(bottomLeft, bottomRight);
    }

    public boolean intersects(Rectangle other) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "(" + this.topLeftLatitude + "," + this.topLeftLongitude + "), (" + this.bottomRightLatitude + "," + this.bottomRightLongitude + ")";
    }

    boolean wrapsDateLine() {
        return this.topLeftLongitude > this.bottomRightLongitude;
    }

    static Rectangle create(double y1, double y2, double x1, double x2) {
        return new Rectangle(Math.min(y1, y2), Math.max(y1, y2), Math.min(x1, x2), Math.max(x1, x2));
    }

    public static Rectangle create(Position topLeft, Position bottomRight) {
        return new Rectangle(topLeft.getLatitude(), topLeft.getLongitude(), bottomRight.getLatitude(), bottomRight.getLongitude());
    }

    public static Rectangle fromJSON(CharSequence string) {
        return MessageSerializer.readFromJSON(SERIALIZER, string);
    }
}

