/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.maritimecloud.util.geometry.Area;
import net.maritimecloud.util.geometry.CoordinateSystem;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionReader;
import net.maritimecloud.util.geometry.PositionTime;
import net.maritimecloud.util.units.SpeedUnit;

public final class PositionReaderSimulator {
    final Random random;
    DoubleSupplier speedSource;
    LongSupplier timeSource = new LongSupplier(){

        @Override
        public long getAsLong() {
            return System.currentTimeMillis();
        }
    };

    public PositionReaderSimulator() {
        this(new Random());
        this.setSpeedVariable(1.0, 40.0, SpeedUnit.KNOTS);
    }

    public PositionReaderSimulator(Random random) {
        this.random = Objects.requireNonNull(random);
        this.setSpeedVariable(1.0, 40.0, SpeedUnit.KNOTS);
    }

    PositionReader forA(Supplier<Position> supplier) {
        return new AbtractSimulatedReader(this, supplier);
    }

    public PositionReader forArea(final Area area) {
        final Random r = this.random;
        return this.forA(new Supplier<Position>(){

            @Override
            public Position get() {
                return r == null ? area.getRandomPosition() : area.getRandomPosition(r);
            }
        });
    }

    public PositionReader forRoute(Position ... positions) {
        LinkedList<Position> l = new LinkedList<Position>(Arrays.asList(positions));
        new ConcurrentLinkedQueue<Position>(l);
        if (l.size() < 2) {
            throw new IllegalArgumentException("Must specified at least 2 positions");
        }
        if (l.getFirst().equals(l.getLast())) {
            l.removeLast();
        } else if (l.size() > 2) {
            LinkedList<Position> l2 = new LinkedList<Position>(l);
            l2.removeFirst();
            l2.removeLast();
            l.addAll(l2);
        }
        final Position[] p = l.toArray(new Position[l.size()]);
        return this.forA(new Supplier<Position>(){
            int counter;
            {
                this.counter = p.length - 1;
            }

            @Override
            public Position get() {
                this.counter = (this.counter + 1) % p.length;
                return p[this.counter];
            }
        });
    }

    public PositionReaderSimulator setSpeedFixed(double speed, SpeedUnit speedUnit) {
        if (speed <= 0.0) {
            throw new IllegalArgumentException("Speed must be positive (>0)");
        }
        final double metersPerSecond = speedUnit.toMetersPerSecond(speed);
        this.speedSource = new DoubleSupplier(){

            @Override
            public double getAsDouble() {
                return metersPerSecond;
            }
        };
        return this;
    }

    public PositionReaderSimulator setSpeedVariable(double minSpeed, double maxSpeed, SpeedUnit speedUnit) {
        if (minSpeed <= 0.0) {
            throw new IllegalArgumentException("Minimum Speed must be positive (>0), was " + minSpeed);
        }
        if (maxSpeed <= minSpeed) {
            throw new IllegalArgumentException("Maximum Speed must greater than minimum speed, minSpeed= " + minSpeed + ", maxSpeed=" + maxSpeed);
        }
        final double metersPerSecondMin = speedUnit.toMetersPerSecond(minSpeed);
        final double metersPerSecondMax = speedUnit.toMetersPerSecond(maxSpeed);
        this.speedSource = new DoubleSupplier(){

            @Override
            public double getAsDouble() {
                return Area.nextDouble(PositionReaderSimulator.this.random, metersPerSecondMin, metersPerSecondMax);
            }
        };
        return this;
    }

    public PositionReaderSimulator setTimeSource(LongSupplier timeSource) {
        this.timeSource = Objects.requireNonNull(timeSource);
        return this;
    }

    public PositionReaderSimulator setTimeSourceFixedSlice(final long milliesIncrement) {
        if (milliesIncrement <= 0L) {
            throw new IllegalArgumentException();
        }
        return this.setTimeSource(new LongSupplier(){
            final AtomicLong al = new AtomicLong();

            @Override
            public long getAsLong() {
                return this.al.incrementAndGet() * milliesIncrement;
            }
        });
    }

    static class AbtractSimulatedReader
    extends PositionReader {
        PositionTime currentPosition;
        double currentSpeed;
        DoubleSupplier distanceSupplier;
        final Supplier<Position> positionSupplier;
        Position target;
        final LongSupplier timeSource;

        AbtractSimulatedReader(PositionReaderSimulator prs, Supplier<Position> positionSupplier) {
            this.timeSource = Objects.requireNonNull(prs.timeSource);
            this.positionSupplier = Objects.requireNonNull(positionSupplier);
            this.currentPosition = positionSupplier.get().withTime(this.timeSource.getAsLong());
            this.target = positionSupplier.get();
            this.distanceSupplier = prs.speedSource;
            this.currentSpeed = this.distanceSupplier.getAsDouble();
        }

        @Override
        public final PositionTime getCurrentPosition() {
            long now = this.timeSource.getAsLong();
            if (now <= this.currentPosition.getTime()) {
                return this.currentPosition;
            }
            double distanceSailed = this.currentSpeed * (double)(now - this.currentPosition.getTime()) / 1000.0;
            while (true) {
                double distanceToTarget;
                if (distanceSailed <= (distanceToTarget = this.currentPosition.rhumbLineDistanceTo(this.target))) {
                    this.currentPosition = CoordinateSystem.CARTESIAN.pointOnBearing(this.currentPosition, distanceSailed, this.currentPosition.rhumbLineBearingTo(this.target)).withTime(now);
                    return this.currentPosition;
                }
                distanceSailed -= distanceToTarget;
                this.currentPosition = this.target.withTime(0L);
                this.target = this.positionSupplier.get();
                this.currentSpeed = this.distanceSupplier.getAsDouble();
            }
        }
    }
}

