/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.maritimecloud.internal.message.BinaryUtil;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.geometry.CoordinateSystem;
import net.maritimecloud.util.geometry.PositionTime;

public class Position
implements Message,
Serializable {
    static final double POS_INT_SCALE = 1.0E7;
    public static final MessageSerializer<Position> SERIALIZER = new MessageSerializer<Position>(){

        @Override
        public Position read(MessageReader reader) throws IOException {
            double lat = reader.readDouble(1, "latitude");
            double lon = reader.readDouble(2, "longitude");
            return Position.create(lat, lon);
        }

        @Override
        public void write(Position message, MessageWriter writer) throws IOException {
            writer.writeDouble(1, "latitude", message.latitude);
            writer.writeDouble(2, "longitude", message.longitude);
        }
    };
    private static final long serialVersionUID = 1L;
    final double latitude;
    final double longitude;

    Position(double latitude, double longitude) {
        this.latitude = Position.verifyLatitude(latitude);
        this.longitude = Position.verifyLongitude(longitude);
    }

    public boolean equals(Object other) {
        return other instanceof Position && this.equals((Position)other);
    }

    public boolean equals(Position other) {
        return other == this || other != null && this.latitude == other.latitude && this.longitude == other.longitude;
    }

    public double geodesicDistanceTo(Position other) {
        return CoordinateSystem.GEODETIC.distanceBetween(this, other);
    }

    public double geodesicFinalBearingTo(Position other) {
        return CoordinateSystem.vincentyFormula(this.getLatitude(), this.getLongitude(), other.getLatitude(), other.getLongitude(), CoordinateSystem.VincentyCalculationType.FINAL_BEARING);
    }

    public double geodesicInitialBearingTo(Position other) {
        return CoordinateSystem.vincentyFormula(this.getLatitude(), this.getLongitude(), other.getLatitude(), other.getLongitude(), CoordinateSystem.VincentyCalculationType.INITIAL_BEARING);
    }

    public long getCell(double degress) {
        if (degress < 1.0E-4) {
            throw new IllegalArgumentException("degress = " + degress);
        }
        if (degress > 100.0) {
            throw new IllegalArgumentException("degress = " + degress);
        }
        return (long)(Math.floor(this.getLatitude() / degress) * (360.0 / degress)) + (long)((360.0 + this.getLongitude()) / degress) - (long)(360.0 / degress);
    }

    public int getCellInt(double degress) {
        if (degress < 0.01) {
            throw new IllegalArgumentException("degress = " + degress);
        }
        return (int)this.getCell(degress);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public String getLatitudeAsString() {
        double lat = this.latitude;
        if (lat < 0.0) {
            lat *= -1.0;
        }
        int hours = (int)lat;
        lat -= (double)hours;
        lat *= 60.0;
        StringBuilder latitudeAsString = new StringBuilder(16);
        latitudeAsString.append(Position.format00(hours));
        latitudeAsString.append(" ");
        latitudeAsString.append(Position.format00((int)lat));
        latitudeAsString.append(".");
        latitudeAsString.append(Position.format000((int)Math.round(1000.0 * (lat - (double)((int)lat)))));
        latitudeAsString.append(this.latitude < 0.0 ? "S" : "N");
        return latitudeAsString.toString();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getLongitudeAsString() {
        double lon = this.longitude;
        if (lon < 0.0) {
            lon *= -1.0;
        }
        int hours = (int)lon;
        lon -= (double)hours;
        lon *= 60.0;
        StringBuilder longitudeAsString = new StringBuilder(16);
        longitudeAsString.append(Position.format000(hours));
        longitudeAsString.append(" ");
        longitudeAsString.append(Position.format00((int)lon));
        longitudeAsString.append(".");
        longitudeAsString.append(Position.format000((int)Math.round(1000.0 * (lon - (double)((int)lon)))));
        longitudeAsString.append(this.longitude < 0.0 ? "W" : "E");
        return longitudeAsString.toString();
    }

    public int hashCode() {
        long latLong = Double.doubleToLongBits(this.latitude);
        long lonLong = Double.doubleToLongBits(this.longitude);
        return (int)(latLong ^ latLong >>> 32) ^ (int)(lonLong ^ lonLong >>> 32);
    }

    @Override
    public Position immutable() {
        return this;
    }

    public double rhumbLineBearingTo(Position position) {
        double lat1 = Math.toRadians(this.latitude);
        double lat2 = Math.toRadians(position.latitude);
        double dPhi = Math.log(Math.tan(lat2 / 2.0 + 0.7853981633974483) / Math.tan(lat1 / 2.0 + 0.7853981633974483));
        double dLon = Math.toRadians(position.longitude - this.longitude);
        if (Math.abs(dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        double brng = Math.atan2(dLon, dPhi);
        return (Math.toDegrees(brng) + 360.0) % 360.0;
    }

    public double rhumbLineDistanceTo(Position other) {
        return CoordinateSystem.CARTESIAN.distanceBetween(this, other);
    }

    @Override
    public String toJSON() {
        return MessageSerializer.writeToJSON(this, SERIALIZER);
    }

    public long toPackedLong() {
        float lat = (float)this.getLatitude();
        float lon = (float)this.getLongitude();
        return ((long)Float.floatToRawIntBits(lat) << 32) + (long)Float.floatToRawIntBits(lon);
    }

    public String toString() {
        return "(" + this.getLatitude() + ", " + this.getLongitude() + ")";
    }

    public String toStringDegrees() {
        return "(" + this.getLatitudeAsString() + ", " + this.getLongitudeAsString() + ")";
    }

    public Position withLatitude(double latitude) {
        return new Position(latitude, this.longitude);
    }

    public Position withLongitude(double longitude) {
        return new Position(this.latitude, longitude);
    }

    public PositionTime withTime(long time) {
        return PositionTime.create(this, time);
    }

    void writeToPacked(MessageWriter w, int latId, String latName, int lonId, String lonName) throws IOException {
        w.writeInt(latId, latName, this.getLatitudeAsInt());
        w.writeInt(lonId, lonName, this.getLongitudeAsInt());
    }

    int getLatitudeAsInt() {
        return (int)(this.latitude * 1.0E7);
    }

    int getLongitudeAsInt() {
        return (int)(this.longitude * 1.0E7);
    }

    public static Position create(double latitude, double longitude) {
        return new Position(latitude, longitude);
    }

    private static String format00(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    public static Position fromBinary(Binary b) {
        byte[] bytes = b.toByteArray();
        Position pos = Position.create((double)BinaryUtil.readInt(bytes, 0) / 1.0E7, (double)BinaryUtil.readInt(bytes, 4) / 1.0E7);
        return pos;
    }

    public Binary toBinary() {
        byte[] b = new byte[8];
        BinaryUtil.writeInt(this.getLatitudeAsInt(), b, 0);
        BinaryUtil.writeInt(this.getLongitudeAsInt(), b, 4);
        return Binary.copyFrom(b);
    }

    private static String format000(int value) {
        if (value < 10) {
            return "00" + value;
        }
        if (value < 100) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    public static Position fromPackedLong(long l) {
        return new Position(Float.intBitsToFloat((int)(l >> 32)), Float.intBitsToFloat((int)l));
    }

    public static boolean isValid(double latitude, double longitude) {
        return latitude <= 90.0 && latitude >= -90.0 && longitude <= 180.0 && longitude >= -180.0;
    }

    public static Position random() {
        return Position.random(ThreadLocalRandom.current());
    }

    public static Position random(Random rnd) {
        return Position.create(rnd.nextDouble() * 180.0 - 90.0, rnd.nextDouble() * 360.0 - 180.0);
    }

    public static double verifyLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("Illegal latitude must be between -90 and 90, was " + latitude);
        }
        return latitude == -0.0 ? 0.0 : latitude;
    }

    public static double verifyLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("Longitude must be between -180 and 180, was " + longitude);
        }
        return longitude == -0.0 ? 0.0 : longitude;
    }
}

