/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.geometry.Area;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.Rectangle;

public class Polygon
extends Area
implements Iterable<Position> {
    public static final MessageSerializer<Polygon> SERIALIZER = new MessageSerializer<Polygon>(){

        @Override
        public Polygon read(MessageReader reader) throws IOException {
            List<Position> positions = reader.readList(1, "points", Position.SERIALIZER);
            return Polygon.create(positions.toArray(new Position[positions.size()]));
        }

        @Override
        public void write(Polygon message, MessageWriter writer) throws IOException {
            writer.writeList(1, "points", Collections.unmodifiableList(Arrays.asList(message.positions)), Position.SERIALIZER);
        }
    };
    private static final long serialVersionUID = 1L;
    final Position[] positions;

    public Polygon(Position ... positions) {
        if (positions.length < 3) {
            throw new IllegalArgumentException("A polygon must have at lease 3 points, had " + positions.length);
        }
        if (!positions[0].equals(positions[positions.length - 1])) {
            throw new IllegalArgumentException("The first and last position must be identical");
        }
        this.positions = positions;
    }

    @Override
    public boolean contains(Position position) {
        return this.contains(position.getLatitude(), position.getLongitude());
    }

    boolean contains(double latitude, double longitude) {
        boolean result = false;
        int i = 0;
        int j = this.positions.length - 1;
        while (i < this.positions.length) {
            if (this.positions[i].latitude > latitude != this.positions[j].latitude > latitude && longitude < (this.positions[j].longitude - this.positions[i].longitude) * (latitude - this.positions[i].latitude) / (this.positions[j].latitude - this.positions[i].latitude) + this.positions[i].longitude) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    @Override
    public Rectangle getBoundingBox() {
        double topLeftLatitude = Double.MIN_VALUE;
        double bottom = Double.MAX_VALUE;
        double left = Double.MIN_NORMAL;
        double right = Double.MAX_VALUE;
        for (Position p : this.positions) {
            topLeftLatitude = Math.max(topLeftLatitude, p.getLatitude());
            bottom = Math.min(bottom, p.getLatitude());
            left = Math.max(left, p.getLongitude());
            right = Math.min(right, p.getLongitude());
        }
        return new Rectangle(topLeftLatitude, left, bottom, right);
    }

    @Override
    public Position getRandomPosition(Random random) {
        Rectangle r = this.getBoundingBox();
        for (int i = 0; i < 10000; ++i) {
            Position pos = r.getRandomPosition(random);
            if (!this.contains(pos)) continue;
            return pos;
        }
        throw new IllegalStateException("Could not find a valid random point");
    }

    @Override
    public Polygon immutable() {
        return this;
    }

    @Override
    public boolean intersects(Area other) {
        throw new UnsupportedOperationException();
    }

    public static Polygon create(Position ... positions) {
        return new Polygon(positions);
    }

    public List<Position> getPoints() {
        return Collections.unmodifiableList(Arrays.asList(this.positions));
    }

    @Override
    public Iterator<Position> iterator() {
        return this.getPoints().iterator();
    }
}

