/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.geometry.Area;
import net.maritimecloud.util.geometry.CoordinateConverter;
import net.maritimecloud.util.geometry.Point;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.Rectangle;

public final class Ellipse
extends Area {
    private static final long serialVersionUID = 1L;
    private final double alpha;
    private final double beta;
    private final CoordinateConverter coordinateConverter;
    private final double dx;
    private final double dy;
    private final Position geodeticReference;
    private final double thetaDeg;
    public static final MessageSerializer<Ellipse> SERIALIZER = new MessageSerializer<Ellipse>(){

        @Override
        public Ellipse read(MessageReader reader) throws IOException {
            double alpha = reader.readDouble(1, "alpha");
            double beta = reader.readDouble(2, "beta");
            double theta = reader.readDouble(3, "theta");
            double dx = reader.readDouble(4, "dx");
            double dy = reader.readDouble(5, "dy");
            Position geodeticReference = reader.readPosition(6, "geodeticReference");
            return new Ellipse(geodeticReference, dx, dy, alpha, beta, theta);
        }

        @Override
        public void write(Ellipse message, MessageWriter w) throws IOException {
            w.writeDouble(1, "alpha", message.getAlpha());
            w.writeDouble(2, "beta", message.getBeta());
            w.writeDouble(3, "theta", message.getY());
            w.writeDouble(4, "dx", message.getX());
            w.writeDouble(5, "dy", message.getY());
            w.writePosition(6, "geodeticReference", message.getGeodeticReference());
        }
    };

    public Ellipse(Position geodeticReference, double alpha, double beta, double thetaDeg) {
        this.geodeticReference = geodeticReference;
        this.coordinateConverter = geodeticReference == null ? null : new CoordinateConverter(geodeticReference.longitude, geodeticReference.latitude);
        this.dx = 0.0;
        this.dy = 0.0;
        this.alpha = alpha;
        this.beta = beta;
        this.thetaDeg = thetaDeg;
    }

    public Ellipse(Position geodeticReference, double dx, double dy, double alpha, double beta, double thetaDeg) {
        this.geodeticReference = geodeticReference;
        this.coordinateConverter = geodeticReference == null ? null : new CoordinateConverter(geodeticReference.longitude, geodeticReference.latitude);
        this.dx = dx;
        this.dy = dy;
        this.alpha = alpha;
        this.beta = beta;
        this.thetaDeg = thetaDeg;
    }

    @Override
    public boolean contains(Position position) {
        throw new UnsupportedOperationException();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public Rectangle getBoundingBox() {
        throw new UnsupportedOperationException();
    }

    public Position getGeodeticReference() {
        return this.geodeticReference;
    }

    public double getMajorAxisGeodeticHeading() {
        return CoordinateConverter.cartesian2compass(this.thetaDeg);
    }

    @Override
    public Position getRandomPosition(Random random) {
        throw new UnsupportedOperationException();
    }

    public double getThetaDeg() {
        return this.thetaDeg;
    }

    public double getX() {
        return this.dx;
    }

    public double getY() {
        return this.dy;
    }

    @Override
    public Ellipse immutable() {
        return this;
    }

    @Override
    public boolean intersects(Area other) {
        throw new UnsupportedOperationException();
    }

    public boolean intersects(Ellipse otherEllipse) {
        double h1x = StrictMath.cos(StrictMath.toRadians(this.thetaDeg));
        double h1y = StrictMath.sin(StrictMath.toRadians(this.thetaDeg));
        double h2x = StrictMath.cos(StrictMath.toRadians(otherEllipse.thetaDeg));
        double h2y = StrictMath.sin(StrictMath.toRadians(otherEllipse.thetaDeg));
        double vx = otherEllipse.dx - this.dx;
        double vy = otherEllipse.dy - this.dy;
        double d = StrictMath.sqrt(vx * vx + vy * vy);
        boolean intersects = true;
        double SMALL_NUM = 0.1;
        if (d > 0.1) {
            double cosb1 = (h1x * vx + h1y * vy) / (StrictMath.sqrt(h1x * h1x + h1y * h1y) * d);
            double sinb1 = (h1x * vy - h1y * vx) / (StrictMath.sqrt(h1x * h1x + h1y * h1y) * d);
            double d1 = StrictMath.sqrt(this.alpha * this.alpha * this.beta * this.beta / (this.alpha * this.alpha * sinb1 * sinb1 + this.beta * this.beta * cosb1 * cosb1));
            double cosb2 = (h2x * vx + h2y * vy) / (StrictMath.sqrt(h2x * h2x + h2y * h2y) * d);
            double sinb2 = (h2x * vy - h2y * vx) / (StrictMath.sqrt(h2x * h2x + h2y * h2y) * d);
            double d2 = StrictMath.sqrt(otherEllipse.alpha * otherEllipse.alpha * otherEllipse.beta * otherEllipse.beta / (otherEllipse.alpha * otherEllipse.alpha * sinb2 * sinb2 + otherEllipse.beta * otherEllipse.beta * cosb2 * cosb2));
            intersects = d - d1 - d2 < 0.0;
        }
        return intersects;
    }

    public List<Position> samplePerimeter(int n) {
        ArrayList<Point> unitPerimeter = new ArrayList<Point>(n);
        double pi2 = Math.PI * 2;
        double dtheta = pi2 / (double)n;
        double theta = 0.0;
        do {
            unitPerimeter.add(new Point(this.alpha * StrictMath.cos(theta), this.beta * StrictMath.sin(theta)));
        } while ((theta += dtheta) < pi2);
        ArrayList<Point> rotatedPerimeter = new ArrayList<Point>(n);
        for (Point point : unitPerimeter) {
            Point pr = point.rotate(Point.ORIGIN, this.thetaDeg).translate(this.dx, this.dy);
            rotatedPerimeter.add(pr);
        }
        ArrayList<Position> perimeter = new ArrayList<Position>(n);
        for (Point point : rotatedPerimeter) {
            double lon = this.coordinateConverter.x2Lon(point.getX(), point.getY());
            double lat = this.coordinateConverter.y2Lat(point.getX(), point.getY());
            perimeter.add(Position.create(lat, lon));
        }
        return perimeter;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Ellipse{");
        sb.append("geodeticReference=").append(this.geodeticReference);
        sb.append(", dx=").append(this.dx);
        sb.append(", dy=").append(this.dy);
        sb.append(", alpha=").append(this.alpha);
        sb.append(", beta=").append(this.beta);
        sb.append(", thetaDeg=").append(this.thetaDeg);
        sb.append('}');
        return sb.toString();
    }
}

