/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.geometry.Area;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.Rectangle;

class AreaUnion
extends Area {
    public static final MessageSerializer<AreaUnion> SERIALIZER = new MessageSerializer<AreaUnion>(){

        @Override
        public AreaUnion read(MessageReader reader) throws IOException {
            List<Area> list = reader.readList(1, "areas", Area.SERIALIZER);
            return new AreaUnion(list.toArray(new Area[list.size()]));
        }

        @Override
        public void write(AreaUnion message, MessageWriter writer) throws IOException {
            writer.writeList(1, "areas", Arrays.asList(message.areas), Area.SERIALIZER);
        }
    };
    private static final long serialVersionUID = 1L;
    final Area[] areas;

    AreaUnion(Area ... area) {
        ArrayList<Area> areas = new ArrayList<Area>();
        for (Area ar : area) {
            Objects.requireNonNull(ar);
            if (ar instanceof AreaUnion) {
                areas.addAll(Arrays.asList(((AreaUnion)ar).areas));
                continue;
            }
            areas.add(ar);
        }
        this.areas = areas.toArray(new Area[areas.size()]);
    }

    AreaUnion(List<? extends Area> areas) {
        this(areas.toArray(new Area[areas.size()]));
    }

    @Override
    public boolean contains(Position position) {
        for (Area a : this.areas) {
            if (!a.contains(position)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(AreaUnion other) {
        if (this.areas.length == other.areas.length) {
            List<Object> others = Arrays.asList((Object[])other.areas.clone());
            for (Area area : this.areas) {
                boolean found = false;
                for (int i = 0; i < others.size(); ++i) {
                    Area otherArea = (Area)others.get(i);
                    if (area != otherArea && !area.equals(otherArea)) continue;
                    found = true;
                    others.remove(i);
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return false;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof AreaUnion && this.equals((AreaUnion)other);
    }

    @Override
    public Rectangle getBoundingBox() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getRandomPosition(Random random) {
        throw new UnsupportedOperationException("getRandomPosition is not currently supported");
    }

    public int hashCode() {
        if (this.areas.length == 0) {
            return 0;
        }
        int hashCode = this.areas[0].hashCode();
        for (int i = 1; i < this.areas.length; ++i) {
            hashCode ^= this.areas[i].hashCode();
        }
        return hashCode;
    }

    @Override
    public AreaUnion immutable() {
        return this;
    }

    @Override
    public boolean intersects(Area other) {
        for (Area a : this.areas) {
            if (!a.intersects(other)) continue;
            return true;
        }
        return false;
    }
}

