/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.geometry.AreaUnion;
import net.maritimecloud.util.geometry.Circle;
import net.maritimecloud.util.geometry.Polygon;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.Rectangle;

public abstract class Area
implements Message,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String UNION = "union";
    static final int UNION_TAG = 1;
    static final String CIRCLE = "circle";
    static final int CIRCLE_TAG = 2;
    static final String RECTANGLE = "rectangle";
    static final int RECTANGLE_TAG = 3;
    static final String POLYGON = "polygon";
    static final int POLYGON_TAG = 4;
    static final String ELIPSE = "elipse";
    static final int ELIPSE_TAG = 5;
    public static final MessageSerializer<Area> SERIALIZER = new MessageSerializer<Area>(){

        @Override
        public Area read(MessageReader r) throws IOException {
            if (r.isNext(1, Area.UNION)) {
                return new AreaUnion(r.readList(1, Area.UNION, AreaUnion.SERIALIZER));
            }
            if (r.isNext(2, Area.CIRCLE)) {
                return r.readMessage(2, Area.CIRCLE, Circle.SERIALIZER);
            }
            if (r.isNext(3, Area.RECTANGLE)) {
                return r.readMessage(3, Area.RECTANGLE, Rectangle.SERIALIZER);
            }
            if (r.isNext(4, Area.POLYGON)) {
                return r.readMessage(4, Area.POLYGON, Polygon.SERIALIZER);
            }
            if (r.isNext(5, Area.ELIPSE)) {
                return r.readMessage(4, Area.POLYGON, Polygon.SERIALIZER);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(Area a, MessageWriter w) throws IOException {
            if (a != null) {
                if (a instanceof AreaUnion) {
                    w.writeMessage(1, Area.UNION, (AreaUnion)a, AreaUnion.SERIALIZER);
                } else if (a instanceof Circle) {
                    w.writeMessage(2, Area.CIRCLE, (Circle)a, Circle.SERIALIZER);
                } else if (a instanceof Rectangle) {
                    w.writeMessage(3, Area.RECTANGLE, (Rectangle)a, Rectangle.SERIALIZER);
                } else if (a instanceof Polygon) {
                    w.writeMessage(4, Area.POLYGON, (Polygon)a, Polygon.SERIALIZER);
                } else {
                    throw new UnsupportedOperationException();
                }
            }
        }
    };

    public boolean contains(Area area) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean contains(Position var1);

    public abstract Rectangle getBoundingBox();

    public final Position getRandomPosition() {
        return this.getRandomPosition(ThreadLocalRandom.current());
    }

    public abstract Position getRandomPosition(Random var1);

    public abstract boolean intersects(Area var1);

    @Override
    public String toJSON() {
        return MessageSerializer.writeToJSON(this, SERIALIZER);
    }

    public final Area unionWith(Area other) {
        return new AreaUnion(this, other);
    }

    public static Area fromJSON(CharSequence string) {
        return MessageSerializer.readFromJSON(SERIALIZER, string);
    }

    static double nextDouble(Random r, double least, double bound) {
        return r.nextDouble() * (bound - least) + least;
    }

    public static Area unionOf(Area ... areas) {
        Area[] a = (Area[])areas.clone();
        return new AreaUnion(a);
    }
}

