/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import net.maritimecloud.util.Binary;

public class Timestamp
implements Serializable {
    private static final long serialVersionUID = -1966283025437623663L;
    static final Clock CLOCK = Clock.systemUTC();
    final long value;

    Timestamp(long value) {
        this.value = Timestamp.checkValue(value);
    }

    public Instant asInstant() {
        return Instant.ofEpochMilli(this.value);
    }

    public boolean equals(Object other) {
        return other instanceof Timestamp && ((Timestamp)other).value == this.value;
    }

    public long getTime() {
        return this.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public Timestamp plus(long value, TimeUnit unit) {
        Timestamp.checkValue(value);
        return new Timestamp(value <= Long.MAX_VALUE - this.value ? value + this.value : Long.MAX_VALUE);
    }

    static long checkValue(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Value must be non-negative, was " + value);
        }
        return value;
    }

    public Binary toBinary() {
        byte[] bytes = ByteBuffer.allocate(8).putLong(this.getTime()).array();
        return Binary.copyFrom(bytes);
    }

    public static Timestamp create(long value) {
        return new Timestamp(value);
    }

    public static Timestamp now() {
        return new Timestamp(CLOCK.millis());
    }
}

