/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.bind.DatatypeConverter;
import net.maritimecloud.util.LiteralBinary;
import net.maritimecloud.util.RopeBinary;

public abstract class Binary
implements Iterable<Byte>,
Comparable<Binary> {
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    public static final Binary EMPTY = new LiteralBinary(new byte[0]);
    static final int MAX_READ_FROM_CHUNK_SIZE = 8192;
    static final int MIN_READ_FROM_CHUNK_SIZE = 256;

    Binary() {
    }

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract List<ByteBuffer> asReadOnlyByteBufferList();

    public String base64encode() {
        return Base64.getEncoder().encodeToString(this.toByteArray());
    }

    public String hexString() {
        return DatatypeConverter.printHexBinary((byte[])this.toByteArray());
    }

    public abstract byte byteAt(int var1);

    @Override
    public int compareTo(Binary o) {
        if (this.size() != o.size()) {
            throw new IllegalArgumentException("Can only compare binaries with identical length, this.length =" + this.size() + ", other.length =" + o.size());
        }
        ByteIterator thisIter = this.iterator();
        ByteIterator otherIter = o.iterator();
        while (thisIter.hasNext()) {
            byte ob;
            byte tb = thisIter.nextByte();
            if (tb == (ob = otherIter.nextByte())) continue;
            return Byte.compare(tb, ob);
        }
        return 0;
    }

    public Binary concat(Binary other) {
        int otherSize;
        int thisSize = this.size();
        if ((long)thisSize + (long)(otherSize = other.size()) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Binary would be too long: " + thisSize + "+" + otherSize);
        }
        return RopeBinary.concatenate(this, other);
    }

    public void copyTo(byte[] target, int offset) {
        this.copyTo(target, 0, offset, this.size());
    }

    public void copyTo(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("Source offset < 0: " + sourceOffset);
        }
        if (targetOffset < 0) {
            throw new IndexOutOfBoundsException("Target offset < 0: " + targetOffset);
        }
        if (numberToCopy < 0) {
            throw new IndexOutOfBoundsException("Length < 0: " + numberToCopy);
        }
        if (sourceOffset + numberToCopy > this.size()) {
            throw new IndexOutOfBoundsException("Source end offset < 0: " + (sourceOffset + numberToCopy));
        }
        if (targetOffset + numberToCopy > target.length) {
            throw new IndexOutOfBoundsException("Target end offset < 0: " + (targetOffset + numberToCopy));
        }
        if (numberToCopy > 0) {
            this.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
        }
    }

    public abstract void copyTo(ByteBuffer var1);

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public abstract boolean equals(Object var1);

    protected abstract int getTreeDepth();

    public abstract int hashCode();

    protected abstract boolean isBalanced();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract boolean isValidUtf8();

    public abstract ByteIterator iterator();

    public abstract InputStream newInput();

    protected abstract int partialHash(int var1, int var2, int var3);

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    protected abstract int peekCachedHashCode();

    public final Binary sha256() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("All java implementations should have SHA-256", e);
        }
        md.update(this.toByteArray());
        byte[] digest = md.digest();
        return new LiteralBinary(digest);
    }

    public abstract int size();

    public boolean startsWith(Binary prefix) {
        return this.size() >= prefix.size() && this.substring(0, prefix.size()).equals(prefix);
    }

    public Binary substring(int beginIndex) {
        return this.substring(beginIndex, this.size());
    }

    public abstract Binary substring(int var1, int var2);

    public byte[] toByteArray() {
        int size = this.size();
        byte[] result = new byte[size];
        this.copyToInternal(result, 0, 0, size);
        return result;
    }

    public String toString() {
        return String.format("<Binary@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    public abstract String toString(String var1) throws UnsupportedEncodingException;

    public String toStringUtf8() {
        try {
            return this.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    private static Binary balancedConcat(Iterator<Binary> iterator, int length) {
        Binary result;
        assert (length >= 1);
        if (length == 1) {
            result = iterator.next();
        } else {
            int halfLength = length >>> 1;
            Binary left = Binary.balancedConcat(iterator, halfLength);
            Binary right = Binary.balancedConcat(iterator, length - halfLength);
            result = left.concat(right);
        }
        return result;
    }

    public static Binary copyFrom(byte ... bytes) {
        return Binary.copyFrom(bytes, 0, bytes.length);
    }

    public static Binary copyFrom(byte[] bytes, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(bytes, offset, copy, 0, size);
        return new LiteralBinary(copy);
    }

    public static Binary copyFrom(ByteBuffer bytes) {
        return Binary.copyFrom(bytes, bytes.remaining());
    }

    public static Binary copyFrom(ByteBuffer bytes, int size) {
        byte[] copy = new byte[size];
        bytes.get(copy);
        return new LiteralBinary(copy);
    }

    public static Binary copyFrom(Iterable<Binary> byteStrings) {
        ArrayList<Binary> collection;
        if (!(byteStrings instanceof Collection)) {
            collection = new ArrayList<Binary>();
            for (Binary byteString : byteStrings) {
                collection.add(byteString);
            }
        } else {
            collection = (ArrayList<Binary>)byteStrings;
        }
        Binary result = collection.isEmpty() ? EMPTY : Binary.balancedConcat(collection.iterator(), collection.size());
        return result;
    }

    public static Binary copyFrom(String text, String charsetName) throws UnsupportedEncodingException {
        return new LiteralBinary(text.getBytes(charsetName));
    }

    public static Binary copyFromHex(String text) {
        return Binary.copyFrom(DatatypeConverter.parseHexBinary((String)text));
    }

    public static Binary copyFromBase64(String text) {
        return Binary.copyFrom(Base64.getDecoder().decode(text));
    }

    public static Binary copyFromUtf8(String text) {
        try {
            return new LiteralBinary(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public static Output newOutput() {
        return new Output(128);
    }

    public static Output newOutput(int initialCapacity) {
        return new Output(initialCapacity);
    }

    public static Binary random(int bytes) {
        byte[] b = new byte[bytes];
        ThreadLocalRandom.current().nextBytes(b);
        return Binary.copyFrom(b);
    }

    private static Binary readChunk(InputStream in, int chunkSize) throws IOException {
        int bytesRead;
        int count;
        byte[] buf = new byte[chunkSize];
        for (bytesRead = 0; bytesRead < chunkSize && (count = in.read(buf, bytesRead, chunkSize - bytesRead)) != -1; bytesRead += count) {
        }
        if (bytesRead == 0) {
            return null;
        }
        return Binary.copyFrom(buf, 0, bytesRead);
    }

    public static Binary readFrom(InputStream streamToDrain) throws IOException {
        return Binary.readFrom(streamToDrain, 256, 8192);
    }

    public static Binary readFrom(InputStream streamToDrain, int chunkSize) throws IOException {
        return Binary.readFrom(streamToDrain, chunkSize, chunkSize);
    }

    public static Binary readFrom(InputStream streamToDrain, int minChunkSize, int maxChunkSize) throws IOException {
        Binary chunk;
        ArrayList<Binary> results = new ArrayList<Binary>();
        int chunkSize = minChunkSize;
        while ((chunk = Binary.readChunk(streamToDrain, chunkSize)) != null) {
            results.add(chunk);
            chunkSize = Math.min(chunkSize * 2, maxChunkSize);
        }
        return Binary.copyFrom(results);
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private byte[] buffer;
        private int bufferPos;
        private final ArrayList<Binary> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private final int initialCapacity;

        Output(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = initialCapacity;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[initialCapacity];
        }

        private byte[] copyArray(byte[] buffer, int length) {
            byte[] result = new byte[length];
            System.arraycopy(buffer, 0, result, 0, Math.min(buffer.length, length));
            return result;
        }

        private void flushFullBuffer(int minSize) {
            this.flushedBuffers.add(new LiteralBinary(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            int newSize = Math.max(this.initialCapacity, Math.max(minSize, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[newSize];
            this.bufferPos = 0;
        }

        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    byte[] bufferCopy = this.copyArray(this.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralBinary(bufferCopy));
                }
            } else {
                this.flushedBuffers.add(new LiteralBinary(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }

        public synchronized void reset() {
            this.flushedBuffers.clear();
            this.flushedBuffersTotalBytes = 0;
            this.bufferPos = 0;
        }

        public synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public synchronized Binary toBinary() {
            this.flushLastBuffer();
            return Binary.copyFrom(this.flushedBuffers);
        }

        public String toString() {
            return String.format("<Binary.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        @Override
        public synchronized void write(byte[] b, int offset, int length) {
            if (length <= this.buffer.length - this.bufferPos) {
                System.arraycopy(b, offset, this.buffer, this.bufferPos, length);
                this.bufferPos += length;
            } else {
                int copySize = this.buffer.length - this.bufferPos;
                System.arraycopy(b, offset, this.buffer, this.bufferPos, copySize);
                this.flushFullBuffer(length -= copySize);
                System.arraycopy(b, offset += copySize, this.buffer, 0, length);
                this.bufferPos = length;
            }
        }

        @Override
        public synchronized void write(int b) {
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream out) throws IOException {
            Binary[] binaryArray = this;
            synchronized (this) {
                Binary[] cachedFlushBuffers = this.flushedBuffers.toArray(new Binary[this.flushedBuffers.size()]);
                byte[] cachedBuffer = this.buffer;
                int cachedBufferPos = this.bufferPos;
                // ** MonitorExit[var5_2] (shouldn't be in output)
                for (Binary byteString : cachedFlushBuffers) {
                    byteString.writeTo(out);
                }
                out.write(super.copyArray(cachedBuffer, cachedBufferPos));
                return;
            }
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }
}

